% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_weights.R
\name{case_weights}
\alias{case_weights}
\title{Generate case weights for imbalanced binary data}
\usage{
case_weights(data = NULL, dependent.variable.name = NULL)
}
\arguments{
\item{data}{Data frame containing the response variable. Default: \code{NULL}.}

\item{dependent.variable.name}{Character string specifying the response variable name. Must be a column in \code{data}. Default: \code{NULL}.}
}
\value{
Numeric vector of length \code{nrow(data)} with case weights. Each weight is the inverse of the class frequency: \code{1/n_zeros} for 0s and \code{1/n_ones} for 1s.
}
\description{
Generates case weights to balance binary response variables for use with \code{ranger} models. Used internally by \code{\link[=rf]{rf()}}.
}
\details{
The weighting scheme assigns higher weights to the minority class to balance training:
\itemize{
\item Cases with value 0: weight = \code{1 / n_zeros}
\item Cases with value 1: weight = \code{1 / n_ones}
}
This ensures both classes contribute equally to model training regardless of class imbalance.
}
\examples{
# Imbalanced dataset: 3 zeros, 2 ones
weights <- case_weights(
  data = data.frame(
    response = c(0, 0, 0, 1, 1)
  ),
  dependent.variable.name = "response"
)

weights
# Returns: 0.333, 0.333, 0.333, 0.5, 0.5
# Zeros get weight 1/3, ones get weight 1/2

}
\seealso{
Other preprocessing: 
\code{\link{auto_cor}()},
\code{\link{auto_vif}()},
\code{\link{default_distance_thresholds}()},
\code{\link{double_center_distance_matrix}()},
\code{\link{is_binary}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()},
\code{\link{weights_from_distance_matrix}()}
}
\concept{preprocessing}
