% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mem.R
\name{mem}
\alias{mem}
\title{Compute Moran's Eigenvector Maps from distance matrix}
\usage{
mem(distance.matrix = NULL, distance.threshold = 0, colnames.prefix = "mem")
}
\arguments{
\item{distance.matrix}{Numeric distance matrix between spatial locations.}

\item{distance.threshold}{Numeric value specifying the maximum distance for spatial neighbors. Distances above this threshold are set to zero. Default: \code{0} (no thresholding).}

\item{colnames.prefix}{Character string used as prefix for column names in the output. Default: \code{"mem"}.}
}
\value{
Data frame where each column is a MEM (spatial predictor) representing a different scale of spatial pattern. Columns are named with the pattern \verb{<prefix>_<number>} (e.g., "mem_1", "mem_2").
}
\description{
Computes Moran's Eigenvector Maps (MEMs) from a distance matrix. Returns only eigenvectors with positive spatial autocorrelation, which capture broad to medium-scale spatial patterns.
}
\details{
Moran's Eigenvector Maps (MEMs) are spatial variables that represent spatial structures at different scales. The function creates MEMs through the following steps:
\enumerate{
\item Double-centers the distance matrix using \code{\link[=double_center_distance_matrix]{double_center_distance_matrix()}}
\item Computes eigenvectors and eigenvalues using \code{\link[base:eigen]{base::eigen()}}
\item Normalizes eigenvalues by dividing by the maximum absolute eigenvalue
\item Selects only eigenvectors with positive normalized eigenvalues
}

\strong{Positive vs. negative eigenvalues:}

Eigenvectors with positive eigenvalues represent positive spatial autocorrelation (nearby locations are similar), capturing broad to medium-scale spatial patterns. Eigenvectors with negative eigenvalues represent negative spatial autocorrelation (nearby locations are dissimilar) and are excluded. The returned MEMs are ordered by eigenvalue magnitude, with the first columns capturing the broadest spatial patterns.

These MEMs are used as spatial predictors in \code{\link[=rf_spatial]{rf_spatial()}} to account for spatial autocorrelation in model residuals.
}
\examples{
data(plants_distance)

# Compute MEMs from distance matrix
mems <- mem(distance.matrix = plants_distance)

# View structure
head(mems)
dim(mems)

# Check column names
colnames(mems)[1:5]

}
\seealso{
\code{\link[=mem_multithreshold]{mem_multithreshold()}}, \code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=double_center_distance_matrix]{double_center_distance_matrix()}}

Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
