% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.R
\name{moran}
\alias{moran}
\title{Moran's I test for spatial autocorrelation}
\usage{
moran(
  x = NULL,
  distance.matrix = NULL,
  distance.threshold = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{Numeric vector to test for spatial autocorrelation. Typically model residuals or a response variable.}

\item{distance.matrix}{Numeric distance matrix between observations. Must have the same number of rows as the length of \code{x}.}

\item{distance.threshold}{Numeric value specifying the maximum distance for spatial neighbors. Distances above this threshold are set to zero during weighting. Default: \code{NULL} (automatically set to \code{0}, meaning no thresholding).}

\item{verbose}{Logical. If \code{TRUE}, displays a Moran's scatterplot. Default: \code{TRUE}.}
}
\value{
List of class "moran" with three elements:
\itemize{
\item \code{test}: Data frame containing:
\itemize{
\item \code{distance.threshold}: The distance threshold used
\item \code{moran.i.null}: Expected Moran's I under null hypothesis of no spatial autocorrelation
\item \code{moran.i}: Observed Moran's I statistic
\item \code{p.value}: Two-tailed p-value from normal approximation
\item \code{interpretation}: Text interpretation of the result
}
\item \code{plot}: ggplot object showing Moran's scatterplot (values vs. spatial lag values with linear fit).
\item \code{plot.df}: Data frame with columns \code{x} (original values) and \code{x.lag} (spatially lagged values) used to generate the plot.
}
}
\description{
Computes Moran's I, a measure of spatial autocorrelation that tests whether values are more similar (positive autocorrelation) or dissimilar (negative autocorrelation) among spatial neighbors than expected by chance.
}
\details{
Moran's I is a measure of spatial autocorrelation that quantifies the degree to which nearby observations have similar values. The statistic ranges approximately from -1 to +1:
\itemize{
\item \strong{Positive values}: Similar values cluster together (positive spatial autocorrelation)
\item \strong{Values near zero}: Random spatial pattern (no spatial autocorrelation)
\item \strong{Negative values}: Dissimilar values are adjacent (negative spatial autocorrelation, rare in practice)
}

\strong{Statistical testing:}

The function compares the observed Moran's I to the expected value under the null hypothesis of no spatial autocorrelation (E\link{I} = -1/(n-1)). The p-value is computed using a normal approximation. Results are interpreted at 0.05 significance level.

\strong{Moran's scatterplot:}

The plot shows original values (x-axis) against spatially lagged values (y-axis). The slope of the fitted line approximates Moran's I. Points in quadrants I and III indicate positive spatial autocorrelation; points in quadrants II and IV indicate negative spatial autocorrelation.

This implementation is inspired by the \code{Moran.I()} function in the \href{https://cran.r-project.org/package=ape}{ape} package.
}
\examples{
data(plants_df, plants_distance, plants_response)

# Test for spatial autocorrelation in response variable
moran_test <- moran(
  x = plants_df[[plants_response]],
  distance.matrix = plants_distance,
  distance.threshold = 1000
)

# View test results
moran_test$test

# Access components
moran_test$test$moran.i  # Observed Moran's I
moran_test$test$p.value  # P-value
moran_test$test$interpretation  # Text interpretation

}
\seealso{
\code{\link[=moran_multithreshold]{moran_multithreshold()}}, \code{\link[=get_moran]{get_moran()}}

Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
