% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_diagnostics.R
\name{residuals_diagnostics}
\alias{residuals_diagnostics}
\title{Normality test of a numeric vector}
\usage{
residuals_diagnostics(residuals, predictions)
}
\arguments{
\item{residuals}{Numeric vector, model residuals.}

\item{predictions}{Numeric vector, model predictions.}
}
\value{
A list with four slots:
\itemize{
/item \code{w} W statistic returned by \code{\link[=shapiro.test]{shapiro.test()}}.
/item \code{p.value} p-value of the Shapiro test.
/item \code{interpretation} Character vector, one of "x is normal", "x is not normal".
/item \code{plot} A patchwork plot with the qq plot and the histogram of x.
}
}
\description{
Applies a Shapiro-Wilks test to a numeric vector, and plots the qq plot and the histogram.
}
\details{
The function \code{shapiro.test()} has a hard limit of 5000 cases. If the model residuals have more than 5000 cases, then \code{sample(x = residuals, size = 5000)} is applied to the model residuals before the test.
}
\examples{

data(plants_rf)

y <- residuals_diagnostics(
  residuals = get_residuals(plants_rf),
  predictions = get_predictions(plants_rf)
)
y

}
\seealso{
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_qq_line}},\code{\link[ggplot2]{ggtheme}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{geom_freqpoly}},\code{\link[ggplot2]{geom_abline}}
\code{\link[patchwork]{plot_annotation}}

Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
