% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect.R
\name{create_person_period_data}
\alias{create_person_period_data}
\title{Generates person-period data for any data set, given the bounds defined by the 
training set.}
\usage{
create_person_period_data(individual_data, bounds)
}
\arguments{
\item{individual_data}{A survival data set.}

\item{bounds}{Output from the `generate_bounds` function of this package.}
}
\value{
A data set consisting of the original `individual_data` repeated once for each
interval defined by the `bounds` parameter. Each row will be labeled with an id and
an interval. The output of this function can be passed to either `create_training_data`
or `spect_predict` to genreate modeling data or predictions respectively.
}
\description{
Generates person-period data for any data set, given the bounds defined by the 
training set.
}
\seealso{
[generate_bounds()], [spect_predict()], [create_training_data()]
}
\author{
Stephen Abrams, \email{stephen.abrams@louisville.edu}
}
\keyword{utilities}
