% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpectra.R
\name{plotSpectra}
\alias{plotSpectra}
\title{Plot Spectral Data from Multiple Files}
\usage{
plotSpectra(
  folder = ".",
  file_type = "csv",
  sep = ",",
  header = TRUE,
  normalization = c("none", "simple", "min-max", "z-score", "area", "vector"),
  x_config = NULL,
  x_reverse = FALSE,
  y_trans = c("linear", "log10", "sqrt"),
  x_label = NULL,
  y_label = NULL,
  line_size = 0.5,
  palette = "black",
  plot_mode = c("individual", "overlapped", "stacked"),
  display_names = FALSE,
  vertical_lines = NULL,
  shaded_ROIs = NULL,
  annotations = NULL,
  output_format = "tiff",
  output_folder = NULL
)
}
\arguments{
\item{folder}{Character. Path to the folder containing spectral files. Default is working directory (`"."`).}

\item{file_type}{Character. File extension (without dot) to search for. Default is `"csv"`.}

\item{sep}{Character. Delimiter for file columns. Use `","` for comma-separated (default) or `"\\t"` for tab-delimited files.}

\item{header}{Logical. Whether the files contain a header row. Default is `TRUE`.}

\item{normalization}{Character. Normalization method to apply to y-axis data. Options are:
\describe{
  \item{`"none"`}{No normalization is applied (default).}
  \item{`"simple"`}{Divide by the maximum intensity.}
  \item{`"min-max"`}{Scale intensities to the [0,1] range.}
  \item{`"z-score"`}{Subtract the mean and divide by the standard deviation of intensities.}
  \item{`"area"`}{Divide by the total sum of intensities so the spectrum area = 1.}
  \item{`"vector"`}{Normalize the spectrum as a unit vector by dividing by the square root of the sum of squared intensities (L2 normalization).}
}}

\item{x_config}{Numeric vector of length 3. Specifies x-axis range and breaks: `c(min, max, step)`.}

\item{x_reverse}{Logical. If `TRUE`, reverses the x-axis. Default is `FALSE`.}

\item{y_trans}{Character. Transformation for the y-axis. One of `"linear"`, `"log10"`, or `"sqrt"`. Default is `"linear"`.}

\item{x_label}{Character or expression. Label for the x-axis. Supports mathematical notation via `expression()`.}

\item{y_label}{Character or expression. Label for the y-axis. Supports mathematical notation via `expression()`.}

\item{line_size}{Numeric. Width of the spectral lines. Default is `0.5`.}

\item{palette}{Character or vector. Color setting: a single color (e.g., `"black"`), a ColorBrewer palette name (e.g., `"Dark2"`), or a custom color vector.}

\item{plot_mode}{Character. Plotting style. One of `"individual"` (one plot per spectrum), `"overlapped"` (all in one), or `"stacked"` (faceted). Default is `"individual"`.}

\item{display_names}{Logical. If `TRUE`, adds file names as titles to individual spectra or a legend to combined spectra. Default is `FALSE`.}

\item{vertical_lines}{Numeric vector. Adds vertical dashed lines at given x positions.}

\item{shaded_ROIs}{List of numeric vectors. Each vector must have two elements (`xmin`, `xmax`) to define shaded x regions.}

\item{annotations}{Data frame with columns `file` (file name without extension), `x`, `y`, and `label`. Adds annotation labels to specific points in spectra.}

\item{output_format}{Character. File format for saving plots. Examples: `"tiff"`, `"png"`, `"pdf"`. Default is `"tiff"`.}

\item{output_folder}{Character. Path to folder where plots are saved. If NULL (default), plots are not saved; if `"."`, plots are saved in the working directory.}
}
\value{
Saves plots to a specified output folder. Returns `NULL` (used for side-effects).
}
\description{
Reads, normalizes and plots spectral data from files in a folder. Supports multiple plot modes, color palettes, axis customization, annotations and automatic saving of plots to files.
}
\details{
Color settings can support color-blind-friendly palettes from `RColorBrewer`. Use `display.brewer.all(colorblindFriendly = TRUE)` to preview.
}
\examples{
# Create a temporary directory and write mock spectra files
tmp_dir <- tempdir()
write.csv(data.frame(Energy = 0:30, Counts = rpois(31, lambda = 100)),
          file.path(tmp_dir, "spec1.csv"), row.names = FALSE)
write.csv(data.frame(Energy = 0:30, Counts = rpois(31, lambda = 120)),
          file.path(tmp_dir, "spec2.csv"), row.names = FALSE)

# Plot the mock spectra using various configuration options
plotSpectra(
  folder = tmp_dir,
  file_type = "csv",
  sep = ",",
  normalization = "min-max",
  x_config = c(0, 30, 5),
  x_reverse = FALSE,
  y_trans = "linear",
  x_label = expression(Energy~(keV)),
  y_label = expression(Counts/1000~s),
  line_size = 0.7,
  palette = c("black","red"),
  plot_mode = "overlapped",
  display_names = TRUE,
  vertical_lines = c(10, 20),
  shaded_ROIs = list(c(12, 14), c(18, 22)),
  output_format = "png",
  output_folder = tmp_dir
)

}
