% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLOMB.R
\name{plot.lomb}
\alias{plot.lomb}
\title{plot method for Lomb-Scargle periodograms}
\usage{
\method{plot}{lomb}(
  x,
  FAPcol = 1,
  FAPlwd = 1,
  FAPlty = "dashed",
  FAPlim = c(1, 0.001),
  FAPlab = "FAP",
  legend.pos = "topleft",
  legend.cex = 1,
  legend.on = T,
  legend.text = c("Spectrum", "False Alarm Probability"),
  legend.lwd = NULL,
  legend.lty = NULL,
  legend.col = NULL,
  xlab = "Frequency",
  ylab = "Normalized PSD",
  main = "",
  ...
)
}
\arguments{
\item{x}{object of class \code{lomb}}

\item{FAPcol}{color of the FAP line}

\item{FAPlwd}{line width of the FAP line}

\item{FAPlty}{line type for the FAP graph}

\item{FAPlim}{limits to the FAP}

\item{FAPlab}{label of the right vertical axis}

\item{legend.pos}{position of the legend}

\item{legend.cex}{cex value for the legend}

\item{legend.on}{logical, wheater to draw a legend or not}

\item{legend.text}{legend text}

\item{legend.lwd}{line width}

\item{legend.lty}{line type}

\item{legend.col}{color vector of the legend elements}

\item{xlab}{a label for the x axis, defaults to a description of \code{x}.}

\item{ylab}{a label for the y axis, defaults to a description of \code{y}.}

\item{main}{setting the title of the plot}

\item{...}{further parameters to the plot function}
}
\description{
This method plots a standard Lomb-Scargle periodogram, which contains the
normalized power spectra \code{PSD} and the corresponding false alarm
probability \code{p}. For more details refer to Zechmeister et al. (2009).
}
\details{
The \code{plot.lomb} function is a wrapper function for R's standard scatter \code{plot}
To switch off certain properties, simply overwrite the parameter. For example
\code{log = ""} will reset the plot axis back to non-log scale.
}
\examples{
# See spec.lomb

}
\references{
M. Zechmeister and M. Kurster, "The generalised Lomb-Scargle periodogram.
A new formalism for the floating-mean and Keplerian periodograms",
Astronomy & Astrophysics, 496(2), pp. 577--584, 2009.
}
\seealso{
\code{\link{spec.lomb}}
}
