% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyBalance.R
\name{polyBalance}
\alias{polyBalance}
\title{Balance of a phylogenetic tree with polytomies}
\usage{
polyBalance(phy)
}
\arguments{
\item{phy}{A tree of class `phylo'.}
}
\value{
A numeric matrix with two columns and one row for each node of the
tree. The columns give the numbers of descendants on each node.
Non-dichotomous nodes are reported as 'NA'.
}
\description{
This function computes the numbers of descendants for each dichotomous
branch of a phylogenetic tree.
}
\details{
The function extends \code{\link[ape]{balance}} to allow the balance of a tree
with polytomies to be calculated. When the tree is fully dichotomous, the
result is identical to \code{\link[ape]{balance}}.
}
\examples{

	set.seed(55)
	tr <- ape::rtree(15)
	tr2 <- ape::di2multi(tr, tol=0.02)
	polyBalance(tr)
	polyBalance(tr2)

}
\seealso{
\code{\link[ape]{balance}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Utilities}
