% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{is_any_layer_class}
\alias{is_any_layer_class}
\title{Check ggplot layers for use of a specific geom}
\usage{
is_any_layer_class(ggplot, class_nm = "GeomDensity")
}
\arguments{
\item{ggplot}{Check the layers of this ggplot object}

\item{class_nm}{The class name to check, note this differs slightly from
the name of the geom function. Defaults to "GeomDensity", checking to see if
geom_density was used in any of the layers.}
}
\description{
Checks if any of the layers of a ggplot contain a specific class.
}
\examples{
library(ggplot2)
library(spinifex)

g <- ggplot(mtcars, aes(disp, color = factor(cyl))) + 
  geom_density() + geom_histogram()
is_any_layer_class(g, "GeomDensity")
is_any_layer_class(g, "GeomPoint")
}
\seealso{
\code{\link[ggplot2:theme]{ggplot2::theme}} for all theme options.
}
