% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_ctxml.R
\name{print_ctxml}
\alias{print_ctxml}
\title{Print xml document created using spiritR}
\usage{
print_ctxml(ctxml)
}
\arguments{
\item{ctxml}{The xml document generated by a call to create_ctxml()}
}
\description{
This function allows you to easily view the structure of the xml document
generated using the create_ctxml() function
}
\examples{
args_ctxml <- list(
org_name = "UHNToronto",
org_study_id = "Foo trial 20190806",
brief_title = "Foo trial to test auto upload 20190806",
study_acronym = "N/A",
official_title = "Foo trial to test auto upload: A randomized trial new 20190806",
agency  = "Aaron Conway",
resp_party_type = "Sponsor-Investigator",
investigator_username = "aconway",
investigator_title ="Assistant Professor",
brief_summary = "Lay summary here",
start_date = "2019-10",
primary_compl =  "2020-12",
study_compl = "2020-12",
int_subtype = "Health Services Research",
phase = "N/A",
assignment = "Parallel",
allocation = "Randomized",
no_masking =  "False",
masked_subject = "True",
masked_caregiver = "True",
masked_investigator = "True",
masked_assessor = "True",
number_arms = 2,
sample_size = "40",
eligibility_criteria = "Inclusion Criteria
- Adults
Exclusion Criteria
- Children",
healthy_volunteers = "No",
genders_included = "Both",
gender_based = "No",
min_age = "1 years",
max_age = "N/A",
#Central contact
contact_first_name = "Aaron",
contact_last_name = "Conway",
contact_degrees = "PhD",
contact_phone = "649-728-8499",
contact_email = "aaron.conway@utoronto.ca",
#Overall official
official_first_name = "Aaron",
official_last_name ="Conway",
official_degrees = "PhD",
official_affiliation = "UHN",
official_role = "Study Principal Investigator",
#Sharing statements
ipd_sharing = "Yes",
ipd_description = "details",
ipd_protocol =  "True",
ipd_sap = "True",
ipd_icf = "True",
ipd_csr = "True",
ipd_code = "True",
ipd_time = "details",
ipd_criteria = "details",
ipd_url = "http://www.aaronconway.info"
)

ctxml <- do.call(create_ctxml, args_ctxml)

print_ctxml(ctxml)

}
