% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload_ctxml.R
\name{upload_ctxml}
\alias{upload_ctxml}
\title{Upload an xml object to the clinicaltrials.gov registry}
\usage{
upload_ctxml(ctxml, org_name, user_name, password)
}
\arguments{
\item{ctxml}{A xml document created using  create_ctxml() and updated with
any add_arms(), add_interventions(), add_pr_outcomes() and add_sec_outcomes()
that may be required.}

\item{org_name}{The organisation name associated with a clinicaltrials.gov
account}

\item{user_name}{Username for a clinicaltrials.gov account}

\item{password}{Password for a clinicaltrials.gov account}
}
\value{
A message from a http post request to show that the upload was
successful or unsuccesful
}
\description{
This function will make a http POST request to upload a XML document to the
clinicaltrials.gov registry.
}
\examples{
\dontrun{
upload_ctxml(ctxml = ctxml, org_name ="UHNToronto", user_name = "aconway",
 password = "password")
}

}
