% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_evaluation.R
\name{yR2}
\alias{yR2}
\title{Computes percent of variation in response explained by spline tree.}
\usage{
yR2(model)
}
\arguments{
\item{model}{a model created with splineTree()}
}
\value{
An R^2 goodness measure. 1-SSE/SST where SSE is the sum of squared errors between predicted responses and true
responses, and SST is sum of squared errors of true responses around population mean. Note that if the tree passed in was built
without an intercept, this function will return NULL.
}
\description{
Computes the percentage of variation in response explained by the spline tree.
This metric is only meaningful if model$intercept==TRUE.
If the tree includes an intercept, the measure will be between 0 and 1.
}
\examples{
\donttest{
split_formula <- ~HISP + WHITE + BLACK + SEX + Num_sibs + HGC_FATHER + HGC_MOTHER
tree <- splineTree(split_formula, BMI~AGE, idvar = "ID",
   data = nlsySample, degree = 1, df = 3,
   intercept = TRUE, cp = 0.005)
}
yR2(tree)
}
