% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glspred.R
\name{glspred}
\alias{glspred}
\title{Generate spatial predictions using generalized least squares ('gls')}
\usage{
glspred(
  model = var1 ~ 1,
  trainxy,
  longlatpredx,
  predx,
  corr.args = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{model}{a formula defining the response variable and predictive variables.}

\item{trainxy}{a dataframe contains longitude (long), latitude (lat),
predictive variables and the response variable of point samples. That is,
the location information must be names as 'long' and 'lat'.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point
locations (i.e., the centers of grids) to be predicted, need to be named as
 'long' and 'lat'.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{corr.args}{arguments for 'correlation' in 'gls'. See '?corClasses' in 'nlme'
for details. By default, "NULL" is used. When "NULL" is used,
then 'gls' is actually performing 'lm'.}

\item{weights}{describing the within-group heteroscedasticity structure. Defaults
 to "NULL", corresponding to homoscedastic errors. See '?gls' in 'nlme'
for details.}

\item{...}{other arguments passed on to 'gls'.}
}
\value{
A dataframe of longitude, latitude and predictions.
}
\description{
This function is for generating spatial predictions using  'gls' method
in 'nlme' package.
}
\examples{
\donttest{
library(spm)
library(nlme)

data(petrel)
data(petrel.grid)

gravel <- petrel[, c(1, 2, 6:9, 5)]
range1 <- 0.8
nugget1 <- 0.5

model <- log(gravel + 1) ~  long + lat +  bathy + dist + I(long^2) + I(lat^2) +
I(lat^3) + I(bathy^2) + I(bathy^3) + I(dist^2) + I(dist^3) + I(relief^2) + I(relief^3)

glspred1 <- glspred(model = model, trainxy = gravel,
 longlatpredx = petrel.grid[, c(1:2)], predx = petrel.grid,
 corr.args = corSpher(c(range1, nugget1), form = ~ lat + long, nugget = TRUE))

names(glspred1)

# Back transform 'glspred1$predictions' to generate the final predictions
gls.predictions <- exp(glspred1$predictions) - 1
range(gls.predictions)
}

}
\references{
Pinheiro, J. C. and D. M. Bates (2000). Mixed-Effects Models
in S and S-PLUS. New York, Springer.
}
\author{
Jin Li
}
