% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-baseball.R
\name{baseball_running_lane}
\alias{baseball_running_lane}
\title{Baseball Running Lane}
\usage{
baseball_running_lane(
  running_lane_depth = 0,
  running_lane_length = 0,
  running_lane_start_distance = 0,
  running_lane_thickness = 0
)
}
\arguments{
\item{running_lane_depth}{The distance from the outer edge of the foul line
to the outer edge of the running lane}

\item{running_lane_length}{The total distance of the running lane, from where
it first starts to its terminus near first base}

\item{running_lane_start_distance}{The distance from the back tip of home
plate that the running lane starts}

\item{running_lane_thickness}{The thickness of the chalk line that comprises
the running lane}
}
\value{
A data frame containing the running lane's bounding coordinates
}
\description{
The running lane is entirely in foul territory. The depth should be measured
from the foul-side edge of the baseline to the outer edge of the running lane
mark
}
\details{
All measurements should be given "looking down the line" (e.g. as they would
be measured by an observer standing behind home plate)
}
\keyword{internal}
