% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils2.R
\name{traceplot.spbp}
\alias{traceplot.spbp}
\title{Traceplot method for fitted spbp models}
\usage{
\method{traceplot}{spbp}(spbp, pars = c("beta", "gamma"), ...)
}
\arguments{
\item{spbp}{an object of class `spbp` result of a \code{\link[spsurv]{spbp}} fit.}

\item{pars}{parameters to be selected.}

\item{...}{arguments inherent from \code{\link[rstan]{traceplot}}.}
}
\value{
see \code{\link[rstan]{traceplot}}.
}
\description{
Traceplot of a Bayesian fit \code{\link[spsurv]{spbp}}.
}
\examples{

library("spsurv")
data("veteran")

fit <- bpph(Surv(time, status) ~ karno + factor(celltype),
data = veteran)

traceplot(fit)

}
\seealso{
\code{\link[spsurv]{spbp}}, \code{\link[spsurv]{stan_dens.spbp}}, \code{\link[spsurv]{extract.spbp}}
}
