% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_squids_to_df.R
\name{add_squids_to_df}
\alias{add_squids_to_df}
\title{Add a column with SQUIDs to a data frame}
\usage{
add_squids_to_df(
  x,
  colName = "SQUID",
  warnAgainstOverwriting = TRUE,
  origin = Sys.time(),
  follow = NULL,
  followBy = NULL
)
}
\arguments{
\item{x}{The data frame}

\item{colName}{The name of the column to add; set to \code{NULL} to return the
column instead of the data frame.}

\item{warnAgainstOverwriting}{Whether to throw an error if a column with
name \code{colName} already exists.}

\item{origin}{The origin to use when generating the SQUIDs. This allows
you to reproduce the same sequence of SQUIDs. You can easily get an
origin with \code{\link[=get_current_origin]{get_current_origin()}}. The \code{origin} is a timestamp;
an object of class \code{POSIXct} (see \link{squids-package} for more
details).}

\item{follow}{A vector of one or more SQUIDs (or a list; lists are
recursively \code{unlist()}ed); the highest SQUID will be taken, converted
to a timestamp, and used as \code{origin} (well, 0.01 second later), so that the
new SQUIDs will follow that sequence.}

\item{followBy}{When following a vector of SQUIDs, this can be used to
specify the distance between the two vectors in centiseconds.}
}
\value{
If \code{colName = NULL}, the column with SQUIDs; otherwise, \code{x} with
an additional column named with the value of \code{colName}.
}
\description{
Add a column with SQUIDs to a data frame
}
\examples{
squids::add_squids_to_df(
  mtcars
);
}
