# ssebiEF Package

The **ssebiEF** package provides tools to calculate the Simplified Surface Energy Balance Index
(SSEBI) and the Evaporative Fraction (EF) from raster data. It utilizes albedo and
surface-air temperature difference (TS-TA) to generate the SSEBI or EF raster.

## Installation

You can install the development version of **ssebiEF** directly from your
local folder:

### Requirements

-   The input rasters (`TS` and `TA`) must have the same unit of
    measurement (Kelvin preferably) to ensure accurate calculations of `TS-TA` and 
    Simplified Surface Energy Balance Index (SSEBI) or the Evaporative Fraction (EF).

-   The input rasters (`albedo` and `TS-TA`) must:

    -   Have the same Coordinate Reference System (CRS).
    -   Cover the same geographic extent.

-   If these conditions are not met, the function attempt to align the
    rasters automatically (with warnings).

### Dependencies

The `ssebiEF` package automatically manages the following dependencies: -
`terra` for raster manipulation. - `dplyr` for data manipulation. -
`stats` for statistical calculations.

You do not need to load these packages manually; they are handled
internally by `ssebiEF`

## Examples Usage of the `ssebiEF` Package

To use the `ssebiEF` package, start by loading the necessary library in R.

- Define the paths to the input files (albedo and TS-TA rasters) and
  the output path for the calculated SSEBI raster.

    # Load the necessary package
    library(ssebEF)

    # Input raster paths
    albedo_path <- "path/to/albedo.tif"
    TS_TA_path <- "path/to/TS_TA.tif"

    # Output raster path
    output_path <- "path/to/SSEBI.tif"

    # Calculate SSEBI
    calculate_SSEBI(
      albedo_path = albedo_path,
      TS_TA_path = TS_TA_path,
      output_path = output_path,
      n_intervals = 20,
      percentile = 0.01
    )

    # Check the output
    SSEBI <- terra::rast(output_path)
    plot(SSEBI)
    
    
 - Define the paths to the input files (albedo and TS-TA rasters) and
  the output path for the calculated EF raster.

    # Load the necessary package
    library(ssebiEF)

    # Input raster paths
    albedo_path <- "path/to/albedo.tif"
    TS_TA_path <- "path/to/TS_TA.tif"

    # Output raster path
    output_path <- "path/to/EF.tif"

    # Calculate EF
    calculate_EF(
      albedo_path = albedo_path,
      TS_TA_path = TS_TA_path,
      output_path = output_path,
      n_intervals = 20,
      percentile = 0.01
    )

    # Check the output
    EF <- terra::rast(output_path)
    plot(EF)   
    
