% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigens.R
\name{warn_eigens}
\alias{warn_eigens}
\title{Warn about near-unit-roots in some regimes}
\usage{
warn_eigens(stvar, tol = 0.002, allow_unstab = FALSE)
}
\arguments{
\item{stvar}{object of class \code{"stvar"}}

\item{tol}{if eigenvalue is closer than \code{tol} to its bound, a warning is thrown}

\item{allow_unstab}{If \code{TRUE}, estimates not satisfying the stability condition are allowed. Always \code{FALSE} if
\code{weight_function="relative_dens"}.}
}
\value{
Doesn't return anything.
}
\description{
\code{warn_eigens} warns if the model contains near-unit-roots in some regimes
}
\details{
Warns if, for some regime, some moduli of "bold A" eigenvalues are larger than \code{1 - tol} or
 some eigenvalue of the error term covariance matrix is smaller than \code{tol}.
}
\keyword{internal}
