% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{Perform Smith-Waterman alignment of a read against a reference sequence}
\usage{
align(
  read,
  reference,
  gap_open = 3L,
  gap_extension = 1L,
  start_idx = 0L,
  end_idx = 0L,
  match_score = 2L,
  mismatch_penalty = 2L
)
}
\arguments{
\item{read}{A character string of the read.}

\item{reference}{A character string of the reference.}

\item{gap_open}{Penalty for opening a gap. Default is 3.}

\item{gap_extension}{Penalty for extending a gap. Default is 1.}

\item{start_idx}{Index to start the alignment search. Default is 0.}

\item{end_idx}{Index to end the alignment search.
The default value 0 means using the entire reference length.}

\item{match_score}{An integer for scoring matches,
ranging from 0 to 255. Default is 2.}

\item{mismatch_penalty}{An integer for mismatch penalties,
ranging from 0 to 255. Default is 2.}
}
\value{
A list of class \code{ssw} containing the ssw aligner object
and the alignment results.
}
\description{
Perform Smith-Waterman alignment of a read against a reference sequence
}
\examples{
\dontshow{if (is_installed_ssw_py()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
a <- align("ACGT", "TTTTACGTCCCCC")
a
a$alignment$optimal_score
a$alignment$sub_optimal_score
\dontshow{\}) # examplesIf}
}
