% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ceg.R
\name{create_ceg}
\alias{create_ceg}
\title{Create a Chain Event Graph (CEG)}
\usage{
create_ceg(
  staged_tree_obj,
  level_separation = 1200,
  node_distance = 400,
  label = "posterior",
  view_table = FALSE
)
}
\arguments{
\item{staged_tree_obj}{A staged tree object containing nodes and edges. It should have the following structure:
\itemize{
\item \code{staged_tree_obj$x$nodes} : A data frame of node attributes with columns such as \code{id}, \code{level}, \code{colour}, \code{label}, etc.
\item \code{staged_tree_obj$x$edges} : A data frame of edge attributes with columns such as \code{from}, \code{to}, \code{label1}, \code{label2}, \code{label3}, etc.
}}

\item{level_separation}{Numeric. The level separation value for hierarchical layout in the visualised graph. Default is 1200.}

\item{node_distance}{Numeric. The node distance value for hierarchical layout in the visualised graph. Default is 400.}

\item{label}{A character string specifying the type of label to display on edges. Options include:
\itemize{
\item \code{"prior"}: Uses posterior label information.
\item \code{"prior_mean"}: Uses posterior label information.
\item \code{"posterior"}: Uses posterior label information.
\item \code{"posterior_mean"}: Uses posterior mean label information.
\item \code{"none"}: No labels on edges.
Default is \code{"posterior_mean"}.
}}

\item{view_table}{Logical. Whether to display the summary table of the aggregated CEG data in the console. Default is \code{FALSE}.}
}
\value{
A \code{visNetwork} object representing the Chain Event Graph, including contracted nodes and updated edges.If view_table = TRUE, a coloured table is returned that can be displayed in the viewer, instead of just an update_table which can be viewed in the console.
}
\description{
This function generates a Chain Event Graph (CEG) from a staged tree object and a prior table.
It allows for node contraction and mapping, adjusts edge and node attributes,
and visualizes the graph with specific customisations for labels, colour, and node arrangement.
}
\details{
This function processes the staged tree and prior table, contracts nodes based on connected nodes,
creates aggregated edge summaries, computes posterior and prior mean values, and visualizes the CEG
with hierarchical layout, customizable labels, and node distance adjustments.

The function also provides detailed printing of updated edges and contracted nodes for debugging purposes.
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)

# Cannot run this whole chunk at once as specify_priors needs user input
tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
staged_tree <- staged_tree_prior(coloured_tree, tree_priors)
ceg <- create_ceg(staged_tree, view_table = TRUE)


}
