% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popModel.R
\name{popModel}
\alias{popModel}
\title{popModel}
\usage{
popModel(
  numSpecies,
  numStages,
  numStrains = rep(1, numSpecies),
  timeVec,
  speciesNames,
  stageNames,
  rateFunctions = defaultRateFunctions,
  ICs,
  timeDependLoss = rep(TRUE, numSpecies),
  timeDependDuration = rep(FALSE, numSpecies),
  solverOptions = list(),
  checkForNegs = TRUE,
  ntol = 0.01,
  plotFigs = TRUE,
  saveFig = FALSE,
  figType = "eps",
  figName = "stagePopFig",
  sumOverStrains = TRUE,
  plotStrainsFig = TRUE,
  saveStrainsFig = FALSE,
  strainsFigType = "eps",
  strainsFigName = "strainFig"
)
}
\arguments{
\item{numSpecies}{Number of species (integer)}

\item{numStages}{Number of life-stages in each species (vector)}

\item{numStrains}{Number of strains in each species (vector). Default is 1.}

\item{timeVec}{Vector of times the solution should be output out e.g. seq(1,10,0.1)}

\item{speciesNames}{A vector of strings containing the name for each species.}

\item{stageNames}{A list of n vectors (where n is the number of species) containing the names of each stage for each species.}

\item{rateFunctions}{A list of rate functions to use. See \code{\link{RateFunctions}}}

\item{ICs}{is a list of matrices containing the initial conditions for every stage and strain of each species. These must be zero for all stages apart from the reproductive stage (usually the last stage). Each species has a matrix with the number of columns equal to the number of strains in that species and the number of rows equal to the number of stages in that species. E.g. for 2 species, the first with 2 strains and 3 stages, the second with 1 strain and 1 stage, then for zero starting conditions: ICs=list(matrix(0,ncol=2,nrow=3),matrix(0,ncol=1,nrow=1)). Due to the restrictions on initial conditions, it is recommended that more complicated initial conditions are defined through immigration rates in immigrationFunc}

\item{timeDependLoss}{A vector specifying TRUE/FALSE for each species. If a species has any time dependent per capita death or emigration rates, the entry in the vector must be TRUE. The default is TRUE for each species.}

\item{timeDependDuration}{A vector specifying TRUE/FALSE for each species. If a species has any time dependent stage durations the entry is TRUE for that species. The default is FALSE for each species.}

\item{solverOptions}{Options for the DDE solver. A list containing 'DDEsolver' (can be 'deSolve' or 'PBS'), 'tol' (max error tolerance for DDE solver), 'hbsize' (history buffer size), 'method' (method for DDE solver), 'atol' (absolute tolerance (deSolve only)) and 'dt' (maximum initial timestep (PBS only)). Default is solverOptions=list(DDEsolver='PBS',tol=1e-7,hbsize=1e3,method='lsoda',atol=1e-7,dt=0.1)}

\item{checkForNegs}{If TRUE the function checkSolution is called and the solution for each variable, x, is checked for negative values that are greater in magnitude than ntol*max(x). If negative values occur then the solution is incorect and either the problem is incorrectly specified or the tolerances in the DDE solver need to be smaller. The default is TRUE.}

\item{ntol}{This controls the tolerance on the warning given for negative values when checkSolution is called. The default is 0.01 i.e. negative values whose magnitude is less than 1 percent of the max value of the variable are allowed.}

\item{plotFigs}{If TRUE, results will be automatically plotted during the model run. The default is TRUE.}

\item{saveFig}{Choose to save the figure (TRUE or FALSE). Default is FALSE.}

\item{figType}{Figure format can be 'eps', 'tiff' or 'png'. Default is 'eps'}

\item{figName}{filepath to save figure to. Default is 'stagePopFig'}

\item{sumOverStrains}{If any of the species contain multiple strains then if this is TRUE the output is given as the sum over all the strains in the species. If this is FALSE then the time series for each strain will be in the output. Default is TRUE.}

\item{plotStrainsFig}{If any of the species contain multiple strains then if this is TRUE these will be plotted. Default is TRUE}

\item{saveStrainsFig}{If any of the species contain multiple strains then if this is TRUE the figures for the strains will be saveed}

\item{strainsFigType}{If any of the species contain multiple strains and if saveStrainsFig=TRUE then this is used to choose the type of file the figure is saved as (choose from 'eps', 'png' and 'tiff'). Default is 'eps'.}

\item{strainsFigName}{If any of the species contain multiple strains and if saveStrainsFig=TRUE then this is used to choose the name of file the figure is saved as. Default is created by paste('strainFig',SpeciesName[i]).}
}
\value{
The model output is a matrix where rows are points in time and the columns are the state variables. These are named according to the species names and stage names supplied in inputs; the prefixes 'prob', 'dur' and 'dot' refer to the probability of survival through the stage, the duration of the stage and the rate of change of the variable. 'prob' type variables only appear if the per capita death (or emigration) rate is variable in time and 'dur' only appears if the stage duration is variable in time.
}
\description{
Run the core model.
}
\details{
The default solver options are:

  \code{list('DDEsolver'='deSolve','tol'=1e-7,'hbsize'=1e3,'method'=lsoda,'atol'=1e-7,'dt'=0.1)}

but these may be changed by use of the \code{solverOptions}
parameter. Please see \code{\link{SolverOptions}} for details of this
parameter.
}
\examples{
rateFuncs=list(
  reproFunc=function(x,time,species,strain){
   v=10*x$flies['adults',1]*exp(-x$flies['adults',1]/100)
   return(max(v,0))
 },
 deathFunc=function(stage,x,time,species,strain){
   a=c(0.05,0.1,0.1); return(a[stage])
 },
 durationFunc=function(stage,x,time,species,strain){
   a=c(5,10); return(a[stage])
 },
 immigrationFunc=function(stage,x,time,species,strain){
   v=0
   if (stage==3 & time<1){v=100}; return(v)},
 emigrationFunc=function(stage,x,time,species,strain){return(0)}
)

modelOutput = popModel(
 numSpecies=1,
 numStages=3,
 ICs=list(matrix(0,nrow=3,ncol=1)),
 timeVec=seq(0,100,0.5),
 timeDependLoss=FALSE,
 timeDependDuration=FALSE,
 rateFunctions=rateFuncs,
 solverOptions=list(DDEsolver='PBS',tol=1e-4,hbsize=1e4,dt=0.01),
 stageNames=list(c('eggs','larvae','adults')),
 speciesNames=c('flies'),
 plotFigs=FALSE #change this to TRUE to see graphical output
 )
}
