% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sevt_simplify.R
\name{sevt_simplify}
\alias{sevt_simplify}
\title{Simplify a staged tree model}
\usage{
sevt_simplify(object, fit = TRUE)
}
\arguments{
\item{object}{an object of class \code{sevt}}

\item{fit}{logical, if \code{TRUE} refit the model after simplification.}
}
\value{
an object of class \code{sevt}
representing the simplified model.
The returned model will be fitted if the input \code{model} was.
}
\description{
Function to simplify a staged tree model.
}
\details{
The \code{simplify} function will produce the corresponding simple
staged tree, that is a staged tree where stages and positions are
equivalent.
To do so the function \code{ceg} is used to compute positions, and
then the stages' vectors are replaced with the positions' vectors.
The model is the re-fitted if the input was a fitted staged tree.
Despite the name, the simplified staged tree has always a number
of stages greater or equal to the initial staged tree, thus it is
a more complex statistical model.
}
\examples{
mod <- stages_kmeans(full(Titanic), k = 2)
simpl <- sevt_simplify(mod)
plot(simpl)
}
