% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three-dots-dependencies.R,
%   R/three-dots-handler.R
\name{useThreeDots}
\alias{useThreeDots}
\alias{threeDots}
\title{Three Dots}
\usage{
useThreeDots()

threeDots(uiOutput, type = "elastic", color = "#9880ff")
}
\arguments{
\item{uiOutput}{An output element to be wrapped within a loader.}

\item{type}{The type of animation to use. Visit \url{https://nzbin.github.io/three-dots/} for details.}

\item{color}{The color of the loader. Choose between hexadecimal, RGB or keyword values.}
}
\value{
None
}
\description{
Single element CSS loading animation.
}
\section{Functions}{

\itemize{
\item \code{useThreeDots}: Dependencies to include in your UI.
\item \code{threeDots}: Display loading animation.
}
}

\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useThreeDots(),
      actionButton("render", "Render"),
      threeDots(plotOutput("plot"))
    ),
    server = function(input, output) {
      output$plot <- renderPlot({
        input$render
        Sys.sleep(3)
        hist(mtcars$mpg)
      })
    }
  )
}

}
