% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbitflips.R
\name{nbitflips}
\alias{nbitflips}
\title{A function to compute bitflip statistics and time series}
\usage{
nbitflips(x, ndemb)
}
\arguments{
\item{x}{A numeric vector (e.g. a time series), from which the ordinal pattern distribution is to be calculated}

\item{ndemb}{Embedding dimension of the ordinal patterns (i.e. sliding window size) for which bitflips are to be calculated. Should be chosen such as length(x) >> ndemb}
}
\value{
A list with two entries is returned.
}
\description{
Computation of bitflip statistics of a time series
}
\details{
This function returns a histogram and time series of the number of bitflips occurring in the associated ordinal patterns. NA values are allowed, and any pattern that contains at least one NA value will be ignored. WARNING: Can be slow with very long time series (n > 10^7).
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
nbitflips(x = x, ndemb = 6)
}
\references{
Sippel, S., 2014. Evaluating the carbon dynamics of biogeochemical models using statistical complexity measures. Master Thesis, University of Bayreuth.
}
\author{
Sebastian Sippel
}
