% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaotic_maps.R
\name{schuster_map}
\alias{schuster_map}
\title{A function to generate a time series from the Schuster Map}
\usage{
schuster_map(N, z, start="rand", disregard_N=0)
}
\arguments{
\item{N}{length of the time series that is to be generated}

\item{z}{Schuster map parameter}

\item{start}{start value. Default is to random.}

\item{disregard_N}{Number of values at the beginning of the series to disregard}
}
\value{
A vector of length N
}
\description{
Generates a time series from the Schuster map
}
\examples{
schuster_map(N = 10^4, z=2)
}
\references{
Schuster, H.G., 1988. Deterministic chaos. An Introduction.
}
\author{
Sebastian Sippel
}
