% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSplineParameters.R
\name{estimateSplineParameters}
\alias{estimateSplineParameters}
\title{Extract estimates from fitted splines.}
\usage{
estimateSplineParameters(
  x,
  estimate = c("predictions", "derivatives", "derivatives2"),
  what = c("min", "max", "mean", "AUC", "p"),
  AUCScale = c("min", "hour", "day"),
  timeMin = NULL,
  timeMax = NULL,
  genotypes = NULL,
  plotIds = NULL,
  fitLevel = c("geno", "plot", "genoDev", "plotDev")
)
}
\arguments{
\item{x}{An object of class HTPSpline, the output of the
\code{\link{fitSpline}} function, or class splineHDm, the output of the
\code{\link{fitSplineHDM}} function}

\item{estimate}{The P-Spline component for which the estimate should be
extracted, the predictions, the first derivatives or the second derivatives
("derivatives2")}

\item{what}{The types of estimate that should be extracted. Either minimum
("min"), maximum ("max"), mean, area under the curve ("AUC") or a percentile.
Percentiles should be given as p + percentile. E.g. for the 10th percentile
specify what = "p10". Multiple types of estimate can be extracted at once.}

\item{AUCScale}{The area under the curve is dependent on the scale used on
the x-axis. By default the area is computed assuming a scale in minutes. This
can be changed to either hours or days.}

\item{timeMin}{The lower bound of the time interval from which the
estimates should be extracted. If \code{NULL} the smallest time value for
which the splines were fitted is used. \code{timeMin} should be given as a
numerical value that corresponds to the time scale used for fitting the
splines. See the examples.}

\item{timeMax}{The upper bound of the time interval from which the
estimates should be extracted. If \code{NULL} the largest time value for
which the splines were fitted is used. \code{timeMin} should be given as a
numerical value that corresponds to the time scale used for fitting the
splines. See the examples.}

\item{genotypes}{A character vector indicating the genotypes for which
estimates should be extracted. If \code{NULL}, estimates will be extracted
for all genotypes for which splines where fitted.}

\item{plotIds}{A character vector indicating the plotIds for which
estimates should be extracted. If \code{NULL}, estimates will be extracted
for all plotIds for which splines where fitted.}

\item{fitLevel}{A character string indicating at which level of the data
the parameter estimates should be made. Only used for splines fitted using
\code{\link{fitSplineHDM}}.}
}
\value{
An object of class splineEst, a data.frame containing the
estimated parameters.
}
\description{
Function for extracting parameter estimates from fitted splines on a
specified interval.
}
\examples{
### Estimate parameters for fitted P-splines.

## Run the function to fit P-splines on a subset of genotypes.
subGeno <- c("G160", "G151")
fit.spline <- fitSpline(inDat = spatCorrectedVator,
                        trait = "EffpsII_corr",
                        genotypes = subGeno,
                        knots = 50)

## Estimate the maximum value of the predictions at the beginning of the time course.
## The spline was fitted at a timePoints scale, i.e. date-time so
## timeMin and timeMax should be given at this scale as well.
paramVator <- estimateSplineParameters(x = fit.spline,
                                       estimate = "predictions",
                                       what = "max",
                                       timeMin = 1527784620,
                                       timeMax = 1528500000,
                                       genotypes = subGeno)
head(paramVator)

## Create a boxplot of the estimates.
plot(paramVator, plotType = "box")

## Estimate the minimum and maximum value of the predictions.
paramVator2 <- estimateSplineParameters(x = fit.spline,
                                        estimate = "predictions",
                                        what = c("min", "max"),
                                        genotypes = subGeno)
head(paramVator2)


### Estimate parameters for fitted HDM-splines.

## The data from the Phenovator platform have been corrected for spatial
## trends and outliers for single observations have been removed.

## We need to specify the genotype-by-treatment interaction.
## Treatment: water regime (WW, WD).
spatCorrectedArch[["treat"]] <- substr(spatCorrectedArch[["geno.decomp"]],
                                      start = 1, stop = 2)
spatCorrectedArch[["genoTreat"]] <-
  interaction(spatCorrectedArch[["genotype"]],
             spatCorrectedArch[["treat"]], sep = "_")

## Fit P-Splines Hierarchical Curve Data Model for selection of genotypes.
fit.psHDM  <- fitSplineHDM(inDat = spatCorrectedArch,
                          trait = "LeafArea_corr",
                          genotypes = c("GenoA14_WD", "GenoA51_WD",
                                       "GenoB11_WW", "GenoB02_WD",
                                       "GenoB02_WW"),
                          time = "timeNumber",
                          pop = "geno.decomp",
                          genotype = "genoTreat",
                          plotId = "plotId",
                          difVar = list(geno = FALSE, plot = FALSE),
                          smoothPop = list(nseg = 4, bdeg = 3, pord = 2),
                          smoothGeno = list(nseg = 4, bdeg = 3, pord = 2),
                          smoothPlot = list(nseg = 4, bdeg = 3, pord = 2),
                          weights = "wt",
                          trace = FALSE)

## Estimate minimum, maximum, and mean for predictions at the genotype level.
## The spline was fitted at the timeNumber scale, so timeMax
## should be given at that scale as well.
paramArch <- estimateSplineParameters(x = fit.psHDM,
                                     what = c("min", "max", "mean"),
                                     fitLevel = "geno",
                                     estimate = "predictions",
                                     timeMax = 28)
head(paramArch)

## Create a boxplot of the estimates.
plot(paramArch, plotType = "box")

## Estimate area under the curve for predictions at the plot level.
paramArch2 <- estimateSplineParameters(x = fit.psHDM,
                                      what = "AUC",
                                      fitLevel = "plot",
                                      estimate = "predictions")
head(paramArch2)

}
\seealso{
Other functions for spline parameter estimation: 
\code{\link{plot.splineEst}()}
}
\concept{functions for spline parameter estimation}
