% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countConnected.r
\name{countConnected}
\alias{countConnected}
\title{Count number of contiguous "blocks" of cells}
\usage{
countConnected(x, count = 1)
}
\arguments{
\item{x}{Matrix}

\item{count}{Value to count as a "presence" in the matrix. All other values will be assumed to be not part of a component.}
}
\value{
An integer (the number of connected, non-conterminous components).
}
\description{
This function calculates the number of objects formed by one or more adjacent cells that touch on their edges (i.e., not just at a corner). One way to solve this (inefficiently) is using a "ink-spreading" algorithm that accumulates adjacent cells until all are accounted for, then counts this as a single component. This function uses an efficient solution based on the Euler characteristic.
}
\details{
Inspired by an answer by Alon Amit to the question on Quora, "\emph{What are some programming problems that look hard at a first glance but are actually easy?}".
}
\examples{

v <- c(
1, 1, 0, 1,
1, 1, 0, 0,
1, 0, 0, 0,
0, 0, 0, 1,
0, 0, 1, 1,
1, 0, 0, 0,
0, 0, 0, 0)

x <- matrix(v, ncol=4, byrow=TRUE)
x

countConnected(x)

\dontrun{
# will break because of connection at a vertex
v <- c(
1, 1, 0, 1,
1, 1, 0, 0,
1, 0, 0, 0,
0, 0, 0, 1,
0, 0, 1, 1,
1, 0, 0, 0,
0, 1, 0, 0)

x <- matrix(v, ncol=4, byrow=TRUE)
x

countConnected(x)
}

}
