% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twolines.R
\name{reg2}
\alias{reg2}
\title{Two-Line Interrupted Regression}
\usage{
reg2(f, xc, graph = 1, family = "gaussian", data = NULL)
}
\arguments{
\item{f}{A formula object specifying the model (e.g., y ~ x1 + x2 + x3).
The first predictor is the one on which the u-shape is tested.}

\item{xc}{Numeric value specifying where to set the breakpoint.}

\item{graph}{Integer. If 1 (default), produces a plot. If 0, no plot is generated.}

\item{family}{Character string specifying the family for the GLM model.
Default is "gaussian" for OLS regression. Use "binomial" for probit models.}

\item{data}{A data frame containing the variables in the formula.}
}
\value{
A list containing:
\itemize{
  \item \code{b1}, \code{b2}: Slopes of the two regression lines
  \item \code{p1}, \code{p2}: P-values for the slopes
  \item \code{z1}, \code{z2}: Z-statistics for the slopes
  \item \code{u.sig}: Indicator (0/1) for whether u-shape is significant
  \item \code{xc}: The breakpoint value
  \item \code{glm1}, \code{glm2}: The fitted GLM models
  \item \code{rob1}, \code{rob2}: Robust coefficient test results
  \item \code{msg}: Messages about standard error computation
  \item \code{yhat.smooth}: Fitted smooth values (if graph=1)
}
}
\description{
Performs an interrupted regression analysis with heteroskedastic robust standard errors.
This function fits two regression lines with a breakpoint at a specified value of the
first predictor variable.
}
\details{
This function fits two interrupted regression lines with heteroskedastic robust
standard errors using the sandwich package. The first predictor variable is split
at the breakpoint \code{xc}, creating separate slopes before and after the breakpoint.
}
\keyword{internal}
