% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocov_VAR1.R
\name{autocov_VAR1}
\alias{autocov_VAR1}
\title{Compute the autocovariance matrix for a VAR(1) process.}
\usage{
autocov_VAR1(A, Sigma, lag_max)
}
\arguments{
\item{A}{Coefficient matrix \eqn{A} of the autoregression term.}

\item{Sigma}{Covariance matrix  \eqn{\bm{\Sigma}} of the errors.}

\item{lag_max}{maximum number of lags to compute.}
}
\value{
An array \code{Gamma} of dimension \code{c(m, m, lag_max + 1)},
where the slice \code{Gamma[,,h]} represents the autocovariance at lag
\code{h = 0, 1, ..., lag_max}.
}
\description{
Compute the autocovariance matrix for a VAR(1) process.
}
\details{
Computes the autocovariance matrix \eqn{\bm{\Gamma}(h)} of the
\eqn{m}-dimensional VAR(1) process
\deqn{
  \bm{Y}_t = \bm{A} \bm{Y}_{t-1} + \bm{\epsilon}_t, \quad
  \bm{\epsilon}_t \sim \textrm{N}(\bm{0}, \bm{\Sigma})
}

For the required computation of \eqn{\bm{\Gamma}(0)}, this function
solves the \eqn{m^2 \times m^2} system
\deqn{
\textrm{vec}(\bm{\Gamma}(0)) = [\bm{I} - \bm{A} \otimes \bm{A}]^{-1} \textrm{vec}(\bm{\Sigma}).
}
without directly computing \eqn{m^2 \times m^2} matrices.
}
\examples{
U = matrix(NA, 3, 3)
U[,1] = c(1, 1, 1) / sqrt(3)
U[,2] = c(1, 0, -1) / sqrt(2)
U[,3] = c(0, 1, -1) / sqrt(2)
B = U \%*\% diag(c(0.5, 0.2, 0.1)) \%*\% t(U)
A = (B + t(B)) / 2
Sigma = diag(x = 2, nrow = 3)
autocov_VAR1(A, Sigma, lag_max = 5)

}
