% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoringTable.R
\name{export_ScoringTable}
\alias{export_ScoringTable}
\title{Export ScoringTable}
\usage{
export_ScoringTable(
  table,
  out_file,
  method = c("csv", "json", "object"),
  cond_file
)
}
\arguments{
\item{table}{A \code{ScoringTable} object to export}

\item{out_file}{Output file. Ignored if \code{method = "object"}}

\item{method}{Method for export, either \code{"csv"}, \code{"json"} or \code{"object"}}

\item{cond_file}{Output file for \code{GroupConditions}. Used only
if \code{method = csv} and \code{table} created with \code{GroupedScoreTable}.}
}
\value{
list containing \code{ScoringTable} as a \code{tibble} and \code{GroupConditions}
if \code{method = "object"}. \code{NULL} for other methods
}
\description{
After creation of \code{ScoringTable} it can be handy to export it
into universally recognized and readable format. Two formats are currently
supported: \emph{csv} and \emph{json}. They can be imported back into \code{ScoringTable}
using \code{\link[=import_ScoringTable]{import_ScoringTable()}} function.
\itemize{
\item \emph{csv} format is universally readable - it can be opened, edited
and altered (eg. before publication) in any spreadsheet editor. In case of
\code{ScoringTable} created from \code{GroupedScoreTable}, \code{GroupConditions} can
be exported to another \emph{csv} file, creating two different files.
\item \emph{json} format can be more obtuse, but it allows export of both
\code{ScoringTable} itself and \code{GroupConditions} in the same \emph{json} file.
}
}
\examples{
# Scoring table to export / import #

Consc_ST <- 
  GroupedFrequencyTable(
    data = IPIP_NEO_300,
    conditions = GroupConditions("Sex", "M" ~ sex == "M", "F" ~ sex == "F"), 
    var = "C") |>
  GroupedScoreTable(scale = STEN) |>
  to_ScoringTable(min_raw = 60, max_raw = 300)

#### Export/import method: csv ####

scoretable_csv <- tempfile(fileext = ".csv")
conditions_csv <- tempfile(fileext = ".csv")

export_ScoringTable(
  table = Consc_ST,
  out_file = scoretable_csv,
  method = "csv",
  cond_file = conditions_csv
)

## check if these are regular csv files
writeLines(head(readLines(scoretable_csv)))
writeLines(head(readLines(conditions_csv)))

imported_from_csv <- import_ScoringTable(
  source = scoretable_csv,
  method = "csv",
  cond_file = conditions_csv
)

all.equal(Consc_ST, imported_from_csv)

#### Export/import method: json ####
scoretable_json <- tempfile(fileext = ".json")

export_ScoringTable(
  table = Consc_ST,
  out_file = scoretable_json,
  method = "json"
)

## check if this is regular json file
writeLines(head(readLines(scoretable_json)))

imported_from_json <- import_ScoringTable(
  source = scoretable_json,
  method = "json"
)

all.equal(Consc_ST, imported_from_json)
}
\seealso{
import_ScoringTable

Other import/export functions: 
\code{\link{export_ScaleSpec}()},
\code{\link{import_ScaleSpec}()},
\code{\link{import_ScoringTable}()}
}
\concept{import/export functions}
