% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse}
\alias{collapse}
\title{Concatenate Vector Elements with Optional Separator}
\usage{
collapse(vector, collapse = " ")
}
\arguments{
\item{vector}{A character vector to be concatenated}

\item{collapse}{String to use as separator between elements (default: " ")}
}
\value{
A character string containing the concatenated elements
}
\description{
Concatenates vector elements into a single string. Unlike `paste0`, it handles
single-element vectors without adding a trailing separator.
}
\examples{
# Multiple elements
collapse(c("a", "b", "c"), ", ")  # Returns "a, b, c"

# Single element - no trailing separator
collapse("a", ", ")  # Returns "a"

# With default separator
collapse(c("Hello", "World"))  # Returns "Hello World"

# Empty vector
collapse(character(0), ", ")  # Returns character(0)

}
