% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_read.R
\name{sc_read}
\alias{sc_read}
\title{Read a Data Set for \code{stepcount}}
\usage{
sc_read(
  file,
  sample_rate = NULL,
  resample_hz = "uniform",
  verbose = TRUE,
  keep_pandas = FALSE
)
}
\arguments{
\item{file}{path to the file for reading}

\item{sample_rate}{the sample rate of the data.  Set to \code{NULL}
for \code{stepcount} to try to guess this}

\item{resample_hz}{Target frequency (Hz) to resample the signal. If
"uniform", use the implied frequency (use this option to fix any device
sampling errors). Pass \code{NULL} to disable. Defaults to "uniform".}

\item{verbose}{print diagnostic messages}

\item{keep_pandas}{do not convert the data to a \code{data.frame} and keep
as a \code{pandas} \code{data.frame}}
}
\value{
A list of the data and information about the data
}
\description{
Read a Data Set for \code{stepcount}
}
\note{
The data \code{P30_wrist100} is from
\url{https://ora.ox.ac.uk/objects/uuid:19d3cb34-e2b3-4177-91b6-1bad0e0163e7},
where we took the first 180,000 rows, the first 30 minutes of data
from that participant as an example.
}
\examples{

file = system.file("extdata/P30_wrist100.csv.gz", package = "stepcount")
if (stepcount_check()) {
  out = sc_read(file)
}
\dontrun{
  file = system.file("extdata/P30_wrist100.csv.gz", package = "stepcount")
  if (stepcount_check()) {
    out = sc_read(file, sample_rate = 100L)
  }
}
}
