% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article3.R
\name{article3}
\alias{article3}
\alias{templ_article3}
\title{Steve's 3rd Article/Manuscript Template}
\usage{
article3(...)

templ_article3()
}
\arguments{
\item{...}{Arguments to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document}}.}
}
\description{
Another template for academic articles/manuscripts. Please note that
\code{xelatex} is functionally required for this template/function. An (incomplete)
primer on this tutorial is available on my website
\url{http://svmiller.com/blog/2023/05/a-third-rmarkdown-article-manuscript-template/}.
}
\details{
If your version of TeX comes by way of Yihui Xie's \pkg{tinytex}, you'll want
to additionally install the "xurl" library. Otherwise, you'll get a vague
error about a missing LaTeX dependency. \code{tinytex::tlmgr_install("xurl")}
should suffice. I thank Ian Adams and Cornelius Hennch for finding this issue
and pointing to this solution.
}
\section{About YAML header fields}{
This section documents some of the YAML fields to know
for this template. Just about everything is carried over from the 2nd article
template. The user will want to pay careful attention in the skeleton/example
file about how the YAML is structured for author information.

Do note that Pandoc limitations preclude a more sophisticated "if-else" logic
to formatting authors and their affiliations. This means (basically: strongly
implies) that one of \code{solo-author}, \code{two-author}, or \code{n-author} is explicitly
set to \code{TRUE} for this template to look like it makes sense. You do not need
all three in your YAML. You just need one, and to set it to \code{TRUE}.\tabular{ll}{
   FIELD \tab DESCRIPTION \cr
   \code{author} \tab author information with support for subfields of name, email, author order, and affiliation code \cr
   \code{affils} \tab affiliation information corresponding with the authors. Sync code here with the information in the author field. \cr
   \code{thanks} \tab A place to thank people for their input, identify corresponding author, etc. \cr
   \code{abstract} \tab include an abstract of the paper here \cr
   \code{keywords} \tab some keywords for the manuscript \cr
   \code{anonymous} \tab logical, defaults to \code{FALSE}. If \code{TRUE}, scrubs all identifying author info for peer review \cr
   \code{removetitleabstract} \tab logical, defaults to \code{FALSE}. If \code{TRUE}, removes title/abstract for peer review (if you'd like) \cr
   \code{appendix} \tab optional, but specifies appendix figure/table prefices \cr
   \code{endnotes} \tab logical, defaults to \code{FALSE}. If \code{TRUE}, makes R Markdown footnotes as endnotes \cr
   \code{pandocparas} \tab logical, defaults to \code{FALSE}. If \code{TRUE}, keeps Pandoc's default paragraph format \cr
   \code{sansitup} \tab logical, defaults to \code{FALSE}. If \code{TRUE}, better mimics ACM's use of sans fonts for section headers \cr
   \code{mainfont} \tab optional (I think?), but it's the main font to use with \code{xelatex}. I use \code{cochineal} here. \cr
   \code{sansfont} \tab optional, only necessary if \code{sansitup: TRUE}. Specifies sans font. I recommend Linux Biolinum \cr
   \code{doublespacing} \tab optional, if anything is here to process, this will double-space the document. \cr
   \code{remove-emails} \tab optional, defaults to FALSE. If TRUE, removes author email information from document preamble. \cr
   \code{remove-paper-info} \tab optional, defaults to FALSE. If TRUE, removes optional paper information you may want to include. \cr
   \code{paper-info} \tab Additional information you may want to include about the paper. \cr
   \code{solo-author} \tab Is there only one author on this project? Then set as \code{TRUE}. Has implications for formatting. \cr
   \code{two-author} \tab Are there \emph{only two} authors on this project? Then set as \code{TRUE}. Has implications for formatting. \cr
   \code{n-author} \tab Are there \emph{more than two} authors on this project? Then set as \code{TRUE}. Has implications for formatting. \cr
   \code{alternate-layout} \tab If \code{TRUE}, adjusts the layout slightly (moving affiliations outside the abstract and to near the authors. Experiment with it and see if you like it. \cr
}
}

