#' @export

vmp_est <- function(theta, dt, iter = 2000, lambda_1 = 0, lambda_2 = 0) {
  nc <- length(theta)
  E_lik <- function(par) {
    lambda_vm <- par[1]
    # sigma_vm <- par[2]
    sigma_vm <- sqrt(sum(acos(cos(diff(theta)))^2)/(nc*dt))
    kappa<-2*lambda_vm/sigma_vm^2
    q<-exp(-2*lambda_vm*(besselI(kappa,1)/besselI(kappa,0))*dt)
    mu_vm<-par[2]
    #mu_vm<-par[2]
    ff <- 0
    for (i in 2:nc) {
      ff <- ff + log(vmp_tpd(dt, theta[i], theta[i - 1], lambda_vm, sigma_vm, mu_vm)) - log(normalizing_constant(dt, theta[i - 1], mu_vm, lambda_vm, sigma_vm))
    }
    kappa_vm <- 2 * lambda_vm / (sigma_vm)^2
    a <- sum(1 - cos(diff(theta)))
    return(-ff + lambda_2 * kappa_vm + nc * lambda_1 * a) # 0.01 gigachad kappa also 0.1
  }
  xstart <- c(1,0)
  lower_limit <- c(0.000001,-pi)
  upper_limit <- c(1000,pi)

  fulloptim <- nloptr::nloptr(
    x0 = xstart,
    eval_f = E_lik,
    lb = lower_limit,
    ub = upper_limit,
    opts = list(
      "algorithm" = "NLOPT_LN_BOBYQA",
      "xtol_rel" = 1.0e-8,
      "maxeval" = iter,
      "print_level" = 0
    )
  )

  lambda_vm_est <- fulloptim$solution[1]
  sigma_vm_est <- sqrt(sum(acos(cos(diff(theta)))^2)/(nc*dt))
  mu_vm_est<- fulloptim$solution[2]


  out <- list(lambda_vm = lambda_vm_est, sigma_vm = sigma_vm_est, mu_vm = mu_vm_est, dt=dt, lambda_1=lambda_1, lambda_2=lambda_2)
  class(out) <- "vmp"
  return(out)
}

stoch_vmp_est <- function(S_1, S_2, dt, iter = 2000, lambda_1 = 4.5, lambda_2 = 0, seed = 100) {
  nc <- length(S_1)
  w <- 6
  a <- NULL
  for (i in 1:(nc - w)) {
    a <- c(a, cor(S_1[i:(i + w)], S_2[(i):(i + w)]))
  }

  E_lik <- function(par) {
    rho_vec <- par[1:nc]
    lambda_vm <- par[nc + 1]
    sigma_vm <- sqrt(sum(acos(cos(diff(acos(rho_vec))))^2)/(nc*dt))
    mu1 <- par[nc + 2]
    sigma1 <- par[nc + 3]
    mu2 <- par[nc + 4]
    sigma2 <- par[nc + 5]
    mu_vm<-par[nc+6]
    ff <- 0
    ff <- ff + optim_loop_vmp(dt = dt, rho_vec = rho_vec, lambda_vm = lambda_vm, sigma_vm = sigma_vm, mu_vm = mu_vm, nc = nc, S_1 = S_1, S_2 = S_2, mu1 = mu1, mu2 = mu2, sigma1 = sigma1, sigma2 = sigma2)
    kappa_vm <- 2 * lambda_vm / (sigma_vm)^2
    a <- sum(diff(rho_vec, 1)^2)
    return(-ff + lambda_2 * kappa_vm + nc * lambda_1 * a) # 0.01 gigachad kappa also 0.1
  }
  xstart <- c(a, rep(0, w), 1, 0.1, 0.1, 0.1, 0.1, 0)
  lower_limit <- c(rep(-0.99999, nc), 0.000001, 0.0001, 0.0001, 0.0001, 0.0001, -pi)
  upper_limit <- c(rep(0.99999, nc), 1000, 1, 1, 1, 1, pi)


  set.seed(seed)

  fulloptim <- nloptr::nloptr(
    x0 = xstart,
    eval_f = E_lik,
    lb = lower_limit,
    ub = upper_limit,
    opts = list(
      "algorithm" = "NLOPT_LN_BOBYQA",
      "xtol_rel" = 1.0e-8,
      "maxeval" = iter,
      "print_level" = 0
    )
  )



  rho_est <- fulloptim$solution[1:nc]
  lambda_vm_est <- fulloptim$solution[nc + 1]
  sigma_vm_est <- sqrt(sum(acos(cos(diff(acos(rho_est))))^2)/(nc*dt))
  mu1_est <- fulloptim$solution[nc + 2]
  sigma1_est <- fulloptim$solution[nc + 3]
  mu2_est <- fulloptim$solution[nc + 4]
  sigma2_est <- fulloptim$solution[nc + 5]
  mu_vm_est<- fulloptim$solution[nc + 6]

  out <- list(rho = rho_est, lambda_vm = lambda_vm_est, sigma_vm = sigma_vm_est, mu_vm = mu_vm_est, mu1 = mu1_est, sigma1 = sigma1_est, mu2 = mu2_est, sigma2 = sigma2_est, dt=dt, lambda_1 = lambda_1, lambda_2 = lambda_2)
  class(out) <- "vmp"

  set.seed(NULL)
  return(out)
}
