% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbm.R
\name{rtraj.cbm}
\alias{rtraj.cbm}
\title{Simulate circular Brownian motion}
\usage{
rtraj.cbm(n, theta_0, dt, sigma, burnin=1000)
}
\arguments{
\item{n}{number of steps in the simulated path}

\item{theta_0}{initial point}

\item{dt}{Time step}

\item{sigma}{volatility parameter}

\item{burnin}{number of initial samples to be rejected (Default is 1000)}
}
\value{
A vector of length \code{n} of the simulated path from circular Brownian motion
}
\description{
\code{rtraj.cbm} returns a simulated path of a circular Brownian motion for given parameters
}
\details{
Let \eqn{\theta_t} evolve according to a circular Brownian motion given by,
\deqn{d\theta_t=\sigma dW_t}

We simulate \eqn{\theta_t} by simulating from its transition density.
}
