% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochcorr.R
\name{stochcorr}
\alias{stochcorr}
\title{Estimate a stochastic correlation model}
\usage{
stochcorr(S_1, S_2, dt, corr_process, iter=2000, lambda=4, lambda_1=10, lambda_2=0)
}
\arguments{
\item{S_1}{Historical price of the first asset}

\item{S_2}{Historical price of the second asset}

\item{dt}{Time step}

\item{corr_process}{specify the correlation process, \code{vmp} for von Mises process or \code{cbm} for Circular Brownian Motion}

\item{iter}{Number of iteration (Default is 2000)}

\item{lambda}{regularization parameter for circular Brownian motion (Default is 4)}

\item{lambda_1}{(Default is 10)}

\item{lambda_2}{0 (Default)}
}
\value{
A list containing the estimates of the model including the asset price parameters, instantaneous correlations and
estimates of the correlation process
\itemize{
\item \code{rho} Estimated instantaneous correlations
\item \code{mu_1} Drift of the first asset
\item \code{mu_2} Drift of the second asset
\item \code{sigma_1} Volatility of the first asset
\item \code{sigma_2} Volatility of the second asset
}
if \code{corr_process=vmp} then it additionally returns
\itemize{
\item \code{lambda_vm} the drift parameter of the von Mises process
\item \code{sigma_vm} the volatility parameter of the von Mises process
\item \code{mu_vm} the mean direction of the von Mises process
\item \code{lambda_1, lambda_2} value of the regularization parameters used for estimation
}
else if \code{corr_process=cbm} then it returns
\itemize{
\item \code{sigma_cbm} the volatility parameter of the circular Brownian motion
\item \code{lambda} value of the regularization parameter used for estimation
}
}
\description{
\code{stochcorr} returns the estimates of the instantaneous correlation and other
model parameters.
}
\details{
Let \eqn{S^1_t} and \eqn{S^2_t} be two discretely observed geometric Brownian motions
observed at a time step of dt.
\deqn{dS^1_t=\mu_1S^1_tdt+\sigma_1dW_t^1\\
dS^2_t=\mu_2S^2_tdt+\sigma_2(\rho_tdW_t^1+\sqrt{1-\rho_t^2}dW_t^2)}
where \eqn{\rho_t=\cos\theta_t}, with \eqn{\theta_t} being specified by the von Mises Process
(\eqn{d\theta_t=\lambda\sin(\theta_t-\mu)+\sigma dW_t^3}) or
the Circular Brownian Motion,
\deqn{d\theta=\sigma dW_t^3}
with periodic boundary conditions. Here \eqn{W_t^1,W_t^2,W_t^3} are mutually independent Brownian Motions.

We estimate the model by maximising penalized MLE,  using an iterative optimization procedure. In case of the von Mises process as the correlation process we maximise,
\deqn{\text{Log-lik}-\lambda_1\sum(\rho_{i+1}-\rho_{i})^2-\lambda_2\frac{2\lambda}{\sigma^2}}
For Circular Brownian motion as the correlation process we maximise,
\deqn{\text{Log-lik}-\lambda\sum(\rho_{i+1}-\rho_{i})^2}

See section 4 of Majumdar and Laha (2024) \url{doi:10.48550/arXiv.2412.06343}.
}
\examples{
\donttest{
data("nse2020")

## using von Mises process as the correlation process

a <- stochcorr(nse2020$`USD/INR`, nse2020$Nifty, 1 / 250, corr_process = "vmp")

## using Circular Brownian Motions as the correlation process

a <- stochcorr(nse2020$`USD/INR`, nse2020$Nifty, 1 / 250, corr_process = "cbm")}
}
\seealso{
\code{\link[=stoch.bootstrap]{stoch.bootstrap()}}
}
