#include <Rcpp.h>
#include <math.h>

// [[Rcpp::export]]

double cbm_tpd(double dt,double theta,double theta_0,double sigma){
  // Truncation logic borrowed from R Circular package for wrappednormal, higher sigma
  // would require higher number of terms
  double rr = 2*M_PI;
  double K = (rr+6*sqrt(sigma))/(2*M_PI)+1;
  if(K<10){
    K = 10;
  }

  double s{0};
  for(int i=-K;i<(K+1);i++){
    s=s+exp(-pow(theta-theta_0+2*M_PI*i,2)/(2*pow(sigma*sqrt(dt),2)));
  }

  double p{0};
  p=(1/(sigma*sqrt(dt*2*M_PI)))*s;
  return(p);
}
