// [[ Rcpp :: depends ( RcppArmadillo )]]
#include <RcppArmadillo.h>
#include <math.h>

// [[Rcpp::export]]

double s_given_rho_likelihood(double dt, Rcpp::NumericVector S, Rcpp::NumericVector S_0, Rcpp::NumericVector mu, Rcpp::NumericVector sigma, double rho){
  double S_1 = S[0];
  double S_2 = S[1];

  double S_01 = S_0[0];
  double S_02 = S_0[1];

  double mu1 = mu[0];
  double mu2 = mu[1];

  double sigma1 = sigma[0];
  double sigma2 = sigma[1];

  arma::vec x_vec = {log(S_1),log(S_2)};
  arma::vec mu_vec = {log(S_01)+(mu1-0.5*pow(sigma1,2))*dt,log(S_02)+(mu2-0.5*pow(sigma2,2))*dt};

  arma::mat sigma_matrix(2,2);
  sigma_matrix(0,0) = pow(sigma1,2)*dt;
  sigma_matrix(0,1) = sigma1*sigma2*rho*dt;
  sigma_matrix(1,0) = sigma1*sigma2*rho*dt;
  sigma_matrix(1,1) = pow(sigma2,2)*dt;

  arma::vec diff_vec = x_vec-mu_vec;
  arma::mat f = -0.5*diff_vec.t()*inv(sigma_matrix)*diff_vec - 0.5*log(det(inv(sigma_matrix)));

  return as_scalar(f);
}
