% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contango_hedged.R
\name{contango_hedged}
\alias{contango_hedged}
\title{Backtest a Hedged Contango-Based Volatility Trading Strategy}
\usage{
contango_hedged(contango, xiv.spxu.gains = NULL, vxx.upro.gains = NULL,
  xiv.spxu.cutpoint = 6.36, vxx.upro.cutpoint = 5.45,
  xiv.allocation = 0.46, vxx.allocation = 0.46, xiv.beta = NULL,
  vxx.beta = NULL, initial = 10000)
}
\arguments{
\item{contango}{Numeric vector of contango values at the end of each trading 
day.}

\item{xiv.spxu.gains}{2-column numeric matrix with gains for XIV and SPXU. 
Should have the same number of rows as \code{contango} and be date-shifted 
one value to the right. For example, the first row should have the XIV and 
SPXU gains for the day AFTER the first contango value.}

\item{vxx.upro.gains}{2-column numeric matrix with gains for VXX and UPRO. 
Should have the same number of rows as \code{contango} and be date-shifted 
one value to the right. For example, the first row should have the VXX and 
UPRO gains for the day AFTER the first contango value.}

\item{xiv.spxu.cutpoint}{Numeric value giving the contango cutpoint for
XIV/SPXU position. For example, if \code{xiv.spxu.cutpoint = 5}, XIV/SPXU 
will be held whenever contango is greater than 5\%.}

\item{vxx.upro.cutpoint}{Numeric value giving the contango cutpoint for 
VXX/UPRO position. For example, if \code{vxx.upro.cutpoint = -5}, VXX/UPRO 
will be held whenever contango is less than -5\%.}

\item{xiv.allocation}{Numeric value specifying XIV allocation for XIV/SPXU 
position. For example, if set to 0.46, 46\% is allocated to XIV and 54\% to 
SPXU when contango > \code{xiv.spxu.cutpoint}.}

\item{vxx.allocation}{Numeric value specifying VXX allocation for VXX/UPRO 
position. For example, if set to 0.46, 46\% is allocated to VXX and 54\% to 
UPRO when contango < \code{vxx.upro.cutpoint}.}

\item{xiv.beta}{Numeric value specifying XIV's beta. If specified, the 
function figures out what \code{xiv.allocation} needs to be for zero-beta 
XIV/SPXU positions. For example, if set to 3.5, then 46.2\% XIV/53.8\% SPXU 
achieves zero beta.}

\item{vxx.beta}{Numeric value indicating VXX's beta. If specified, the 
function figures out what \code{vxx.allocation} needs to be for zero-beta 
VXX/UPRO positions. For example, if set to -3.5, then 46.2\% VXX/53.8\% UPRO 
achieves zero beta.}

\item{initial}{Numeric value giving the initial value of the portfolio.}
}
\value{
List containing:
\enumerate{
\item Character vector named \code{holdings} indicating what fund was held 
each day (XIV/SPXU, VXX/UPRO, or cash). 
\item Numeric vector named \code{port.gains} giving the portfolio gain for 
each day, which will be 0 for days that cash was held and the weighted 
XIV/SPXU or VXX/UPRO gain for days that one of those positions was held. 
\item Numeric vector named \code{port.balances} giving the portfolio balance 
each day. 
\item Numeric value named \code{trades} giving the total number of trades 
executed.
}
}
\description{
Implements the following strategy: Each day, hold XIV/SPXU (weighted for zero 
beta) if contango > \code{xiv.spxu.cutpoint}, hold VXX/UPRO (weighted for 
zero beta) if contango < \code{vxx.upro.cutpoint}, and hold cash otherwise. 
Perhaps not very useful since XIV closed on Feb. 20, 2018.
}
\details{
You can find historical contango values from The Intelligent Investor Blog. 
You can click the first link at 
\url{http://investing.kuchita.com/2012/06/28/xiv-data-and-pricing-model-since-vix-futures-available-2004/} 
to download a zip file containing an Excel spreadsheet. Then, you will need 
to calculate whatever version of "contango" you prefer. I typically define 
contango as what percent higher the second-month VIX futures are acompared to 
the first-month futures, i.e. dividing the "2nd mth" column by the "1st mth" 
column, subtracting 1, and then multiplying by 100.

To load daily gains for XIV, SPXU, VXX, and UPRO, you can use 
\code{\link{load_gains}}, which uses the \pkg{quantmod} package to load 
data from Yahoo! Finance. You will have to specify the \code{from} and 
\code{to} inputs to match the date range for your contango values.
}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
