% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gains_graph.R
\name{gains_graph}
\alias{gains_graph}
\title{Scatterplot of Investment Gains}
\usage{
gains_graph(tickers = NULL, ..., gains = NULL, prices = NULL,
  orders = 1, add.plot = FALSE, include.legend = TRUE, colors = NULL,
  lty = NULL, plot.list = NULL, points.list = NULL, legend.list = NULL,
  pdf.list = NULL, bmp.list = NULL, jpeg.list = NULL, png.list = NULL,
  tiff.list = NULL)
}
\arguments{
\item{tickers}{Character vector of ticker symbols that Yahoo! Finance 
recognizes, if you want to download data on the fly.}

\item{...}{Arguments to pass along with \code{tickers} to 
\code{\link{load_gains}}.}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{orders}{Numeric vector specifying the orders of linear regression 
models for each y-axis investment. Set to \code{1} for simple linear 
regression, \code{2} for linear regression with first- and second-order 
terms, and so on.}

\item{add.plot}{Logical value for whether to add plot data to current plot 
frame rather than open a new one.}

\item{include.legend}{Logical value.}

\item{colors}{Character vector of colors for each curve.}

\item{lty}{Numeric vector specifying line types for each curve.}

\item{plot.list}{List of arguments to pass to \code{\link[graphics]{plot}}.}

\item{points.list}{List of arguments to pass to 
\code{\link[graphics]{points}}.}

\item{legend.list}{List of arguments to pass to 
\code{\link[graphics]{legend}}.}

\item{pdf.list}{List of arguments to pass to \code{\link[grDevices]{pdf}}.}

\item{bmp.list}{List of arguments to pass to \code{\link[grDevices]{bmp}}.}

\item{jpeg.list}{List of arguments to pass to \code{\link[grDevices]{jpeg}}.}

\item{png.list}{List of arguments to pass to \code{\link[grDevices]{png}}.}

\item{tiff.list}{List of arguments to pass to \code{\link[grDevices]{tiff}}.}
}
\value{
In addition to the graph, a list containing fitted linear regression models 
returned by \code{\link[stats]{lm}} for each investment vs. the benchmark.
}
\description{
Useful for visualizing relationship between one (or several) investments and 
a benchmark. First fund in \code{tickers}, \code{gains}, or \code{prices} is 
used as the benchmark.
}
\examples{
\dontrun{
# Plot daily gains for SSO and UPRO vs. VFINX
fig <- gains_graph(c("VFINX", "SSO", "UPRO"))
}

}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
