% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srchisq.R
\name{srchisq_custom}
\alias{srchisq_custom}
\title{Sampling from Chi-squared Distribution}
\usage{
srchisq_custom(n = 1, x = NULL)
}
\arguments{
\item{n}{Integer, length 1. Number of samples to draw.}

\item{x}{(optional) Numeric vector of length \eqn{n}. If provided, this vector is over
written in place to avoid any memory allocation.}
}
\value{
A numeric vector of length \code{n} containing random samples from the Chi-squared distribution.
The degrees of freedom (\code{df}) for the distribution are specified during the optimization process using \code{srchisq_optimize()}.
\bold{NOTE:} When the \code{x} parameter is specified, it is updated in-place with the simulation for performance reasons.
}
\description{
The \code{srchisq_custom()} function generates random samples from a Chi-squared Distribution using the STORS algorithm.
It employs an optimized proposal distribution around the mode and Adaptive Rejection Sampling (ARS) for the tails.
}
\details{
The Chi-squared Distribution

The Chi-squared distribution has the probability density function (PDF):
\deqn{f(x | k) = \frac{1}{2^{k/2} \Gamma(k/2)} x^{(k/2) - 1} \exp(-x/2), \quad x \geq 0,}
where:
\describe{
\item{\eqn{k}}{ is the degrees of freedom (\eqn{k > 0}), which determines the shape of the distribution.}
}
The Chi-squared distribution is widely used in hypothesis testing and constructing confidence intervals, particularly in the context of variance estimation.

this function is sampling from proposal that has been constructed using \code{\link{srchisq_optimize}}, using the STORS algorithm.

By default, \code{srchisq_custom()} samples from Chi-squared Distribution \code{df = 2}.
The proposal distribution is pre-optimized at package load time using \code{srchisq_optimize()} with
\code{steps = 4091}, creating a scalable proposal centred around the mode.
}
\note{
This function is not scalable. Therefore, only the \code{srchisq_custom()} version is available, which requires the proposal to be pre-optimized using \code{srchisq_optimize()} before calling this function.
}
\examples{

# Genedf 10 samples from Chi-squared Distribution
samples <- srchisq_custom(10)
print(samples)

# Genedf 10 samples using a pre-allocated vector
x <- numeric(10)
srchisq_custom(10, x = x)
print(x)


}
\seealso{
\code{\link{srchisq_optimize}} to optimize the custom proposal.
}
