% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{a2v}
\alias{a2v}
\title{(3D+) Array to (Atomic) Vector}
\usage{
a2v(a, along = ndim(a):1, use.dimnames = TRUE, sep = "_", check = TRUE)
}
\arguments{
\item{a}{3D+ array.}

\item{along}{numeric vector of length = \code{ndim(a)} that contains the integers
\code{1:ndim(a)} specifying the order which the array elements should be concatenated.
For example, with a 3D array, \code{3:1} (default) specifies to split the array by
layers first, then columns, and then rows. See examples.}

\item{use.dimnames}{logical vector of length 1 that specifies whether the dimnames
of \code{a} should be used to create the names for the returned vector. If FALSE,
the returned vector will have NULL names. If TRUE, then each element's name will
be analogous to \code{paste(dimnames(a)[[1L]][i], dimnames(a)[[2L]][j], dimnames(a)[[3L]][k],
..., sep = sep)}. If \code{a} does not have dimnames, then they will be replaced
by dimension positions.}

\item{sep}{character vector of length 1 specifying the string that will separate
the dimnames from each dimension in the naming scheme of the return object. Note,
\code{sep} is not used if \code{use.dimnames} = FALSE.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{a} is a 3D+ array.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(atomic) vector of length = \code{length(a)} where the order of elements
from \code{a} has been determined by \code{along} and the names determined by
the \code{use.dimnames}, \code{dimnames(a)}, and \code{sep}.
}
\description{
\code{a2v} converts a matrix to a (atomic) vector. The benefit of \code{m2v}
over \code{as.vector} or \code{c} is that 1) the vector can be formed along rows
any sequence of dimensions and 2) the dimnames from \code{a} can be used for
the names of the returned vector.
}
\examples{
a2v(HairEyeColor) # layers, then columns, then rows (default)
a2v(HairEyeColor, along = c(3,1,2)) # layers, then rows, then columns
a2v(HairEyeColor, along = 1:3) # rows, then columns, then layers
a2v(HairEyeColor, along = 1:3, use.dimnames = FALSE)
}
