#' Optimum Sample Allocation in Stratified Sampling
#'
#' @name stratallo-package
#' @aliases stratallo
#' @docType package
#' @title Functions for Optimum Sample Allocation in Stratified Sampling
#' @author Wojciech Wójciak \email{wojciech.wojciak@@gmail.com}
#' @import checkmate
#' @importFrom lifecycle badge
#' @keywords package
#' @references
#'
#'   Stenger, H., Gabler, S. (2005).
#'   Combining random sampling and census strategies -
#'   Justification of inclusion probabilities equal to 1.
#'   *Metrika*, 61(2), pp. 137–156.
#'   \doi{10.1007/s001840400328} \cr
#'
#'   Särndal, C.-E., Swensson, B. and Wretman, J. (1992).
#'   *Model Assisted Survey Sampling*, Springer, New York. \cr
#'
#'   Wesołowski, J., Wieczorkowski, R., Wójciak, W. (2021).
#'   Optimality of the Recursive Neyman Allocation.
#'   *Journal of Survey Statistics and Methodology*, 10(5), pp. 1263–1275.
#'   \doi{10.1093/jssam/smab018},
#'   \doi{10.48550/arXiv.2105.14486} \cr
#'
#'   Wesołowski, J., Wieczorkowski, R., Wójciak, W. (2023).
#'   R Package stratallo - source code (Version 2.2.0).
#'   <https://github.com/wwojciech/stratallo> \cr
#'
#'   Wesołowski, J., Wieczorkowski, R., Wójciak, W. (2023).
#'   Numerical Performance of the RNABOX Algorithm (Version 1.0.1).
#'   <https://github.com/rwieczor/recursive_Neyman_rnabox> \cr
#'
#'   Wójciak, W. (2023).
#'   Another Solution of Some Optimum Allocation Problem.
#'   *Statistics in Transition new series*, 24(5) (in press).
#'   <https://arxiv.org/abs/2204.04035> \cr
#'
#'   Wójciak, W. (2019). Optimal Allocation in Stratified Sampling Schemes.
#'   *MSc Thesis*, Warsaw University of Technology, Warsaw, Poland.
#'   <http://home.elka.pw.edu.pl/~wwojciak/msc_optimal_allocation.pdf>
#'
NULL
