% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_1sided.R
\name{rna_rec}
\alias{rna_rec}
\title{RNA - Recursive Implementation}
\usage{
rna_rec(
  total_cost,
  A,
  bounds = NULL,
  unit_costs = rep(1, length(A)),
  check_violations = .Primitive(">=")
)
}
\arguments{
\item{total_cost}{(\code{number})\cr total cost \eqn{c} of the survey. A strictly
positive scalar.}

\item{A}{(\code{numeric})\cr population constants \eqn{A_1,\ldots,A_H}. Strictly
positive numbers.}

\item{bounds}{(\code{numeric} or \code{NULL}) \cr optional lower bounds
\eqn{m_1,\ldots,m_H}, or upper bounds \eqn{M_1,\ldots,M_H}, or \code{NULL} to
indicate that there is no inequality constraints in the optimization
problem considered.
If not \code{NULL}, the \code{bounds} is to be treated either as:
\itemize{
\item lower bounds, if \code{check_violations = .Primitive("<=")}. In this case, it
is required that \code{total_cost >= sum(unit_costs * bounds)}, \cr
or
\item upper bounds, if \code{check_violations = .Primitive(">=")}. In this case, it
is required that \code{total_cost <= sum(unit_costs * bounds)}.
}}

\item{unit_costs}{(\code{numeric})\cr costs \eqn{c_1,\ldots,c_H}, of surveying one
element in stratum. A strictly positive numbers. Can be also of length 1,
if all unit costs are the same for all strata. In this case, the elements
will be recycled to the length of \code{bounds}.}

\item{check_violations}{(\code{function}) \cr 2-arguments binary operator function
that allows the comparison of values in atomic vectors. It must either be
set to \code{.Primitive("<=")} or \code{.Primitive(">=")}. The first of these choices
causes that \code{bounds} are treated as lower bounds and then \code{rna()} function
performs the \emph{LRNA} algorithm. The latter option causes that \code{bounds}
are treated as upper bounds, and then \code{rna()} function performs the
\emph{RNA} algorithm. This argument is ignored when \code{bounds} is set to \code{NULL}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\note{
this coded was not extensively tested.
}
\examples{
A <- c(3000, 4000, 5000, 2000)
M <- c(100, 90, 70, 80) # upper bounds.
rna_rec(total_cost = 190, A = A, bounds = M)
rna_rec(total_cost = 312, A = A, bounds = M)
rna_rec(total_cost = 339, A = A, bounds = M)
rna_rec(total_cost = 340, A = A, bounds = M)
}
