% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifiedyh.R
\name{stratified_labels}
\alias{stratified_labels}
\title{Stratify and Assign Labels to Data}
\usage{
stratified_labels(df, group_col, yes_percentage)
}
\arguments{
\item{df}{A data frame to be stratified.}

\item{group_col}{A character string specifying the column name to group by.}

\item{yes_percentage}{A numeric value between 0 and 100 indicating the percentage of "Yes" labels to assign within each group.}
}
\value{
A data frame with an additional column "Sampled_Yes_No" containing the stratified "Yes"/"No" labels.
}
\description{
This function stratifies data based on a specified grouping column and assigns "Yes" or "No" labels according to a given percentage.
}
\examples{
# Example with the iris dataset
result <- stratified_labels(iris, group_col = "Species", yes_percentage = 50)
}
