/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;

public class ExperimeterCLI {
    private String[] algorithms;
    private String[] algorithmsID;
    private String[] streams;
    private String[] streamsID;
    private String task;
    private String resultsFolder;
    private String saveExperimentsPath;
    private String[] args;
    private int threads = 1;
    public int[] measures = null;
    public String[] types = null;
    Options options = new Options();
    Options optionsm = new Options();

    public ExperimeterCLI(String[] args) {
        this.args = args;
        this.options.addOption("ls", true, "The names of the algorithms separated by commas");
        this.options.addOption("lss", true, "ID of the algorithms separated by commas");
        this.options.addOption("ds", true, "The names of the streams separated by commas");
        this.options.addOption("dss", true, "ID of the streams separated by commas");
        this.options.addOption("rf", true, "Results folder");
        this.options.addOption("th", true, "Number of threads");
        this.options.addOption("ts", true, "Task");
        this.options.addOption("h", "help", false, "Prints the help message");
        this.optionsm.addOption("h", "help", false, "Prints the help message");
        this.optionsm.addOption("m", true, "The number of measures separated by commas");
        this.optionsm.addOption("tm", true, "The types of measures separated by commas, the types are Mean and Last");
    }

    public boolean summary1CMD(String[] args) {
        BasicParser parser = null;
        CommandLine cmdLine = null;
        try {
            parser = new BasicParser();
            cmdLine = parser.parse(this.optionsm, args);
            if (cmdLine.hasOption("h")) {
                new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.optionsm);
                return false;
            }
            String measure = cmdLine.getOptionValue("m");
            if (measure == null) {
                System.out.println("The measures are required");
                return false;
            }
            if (measure.contains(",")) {
                String[] m = measure.split(",");
                this.measures = new int[m.length];
                for (int i = 0; i < m.length; ++i) {
                    this.measures[i] = Integer.parseInt(m[i]);
                }
            } else {
                this.measures = new int[1];
                this.measures[0] = Integer.parseInt(measure);
            }
            if (cmdLine.hasOption("tm")) {
                String type = cmdLine.getOptionValue("tm");
                if (type.contains(",")) {
                    this.types = type.split(",");
                } else {
                    this.types = new String[1];
                    this.types[0] = type;
                }
            } else {
                this.types = new String[this.measures.length];
                for (int i = 0; i < this.types.length; ++i) {
                    this.types[i] = "Mean";
                }
            }
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.optionsm);
        }
        catch (NumberFormatException ex) {
            new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.optionsm);
        }
        return true;
    }

    public boolean proccesCMD() {
        int threads = 1;
        String algNames = null;
        String algShortNames = null;
        String streamNames = null;
        String streamShortNames = null;
        String task = null;
        String resultsFolder = null;
        BasicParser parser = null;
        CommandLine cmdLine = null;
        try {
            String dir;
            parser = new BasicParser();
            cmdLine = parser.parse(this.options, this.args);
            if (cmdLine.hasOption("h")) {
                new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.options);
                return false;
            }
            if (cmdLine.hasOption("th")) {
                threads = Integer.parseInt(cmdLine.getOptionValue("th"));
                this.setThreads(threads);
            }
            if ((task = cmdLine.getOptionValue("ts")) == null) {
                throw new ParseException("The task is required");
            }
            this.setTask(task);
            algNames = cmdLine.getOptionValue("ls");
            if (algNames == null) {
                throw new ParseException("The name of the algorithms are required");
            }
            try {
                if (algNames.contains(",")) {
                    this.setAlgorithms(algNames.split(","));
                } else {
                    String[] alg = new String[]{algNames};
                    this.setAlgorithms(alg);
                }
            }
            catch (Exception e) {
                System.out.println("Problems with algortihms ls options");
                new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.options);
            }
            if (cmdLine.hasOption("lss")) {
                algShortNames = cmdLine.getOptionValue("lss");
                if (algShortNames.contains(",")) {
                    this.setAlgorithmsID(algShortNames.split(","));
                } else {
                    String[] ash = new String[]{algShortNames};
                    this.setAlgorithmsID(ash);
                }
            } else {
                this.setAlgorithmsID(this.getAlgorithms());
            }
            streamNames = cmdLine.getOptionValue("ds");
            if (streamNames == null) {
                throw new ParseException("The name of the streams are required");
            }
            if (streamNames.contains(",")) {
                this.setStreams(streamNames.split(","));
                for (int i = 0; i < this.getStreams().length; ++i) {
                    String dir2;
                    String ds = this.getStreams()[i];
                    if (!ds.contains(":") || !(dir2 = ds.split(":")[0]).contains(File.separator)) continue;
                    dir2 = dir2.split(File.separator + File.separator)[0];
                    ds = dir2 + ":" + ds.split(":")[1];
                    this.setStreamIndex(i, ds);
                }
            } else {
                String[] str = new String[]{FilenameUtils.separatorsToSystem((String)streamNames)};
                this.setStreams(str);
            }
            if (cmdLine.hasOption("dss")) {
                streamShortNames = cmdLine.getOptionValue("dss");
                if (streamShortNames.contains(",")) {
                    this.setStreamsID(streamShortNames.split(","));
                } else {
                    String[] strh = new String[]{streamShortNames};
                    this.setStreamsID(strh);
                }
            } else {
                this.setStreamsID(this.getStreams());
            }
            resultsFolder = cmdLine.getOptionValue("rf");
            if (resultsFolder == null) {
                File excPath = new File(".");
                try {
                    resultsFolder = excPath.getCanonicalPath();
                }
                catch (IOException ex) {
                    Logger.getLogger(ExperimeterCLI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (resultsFolder.contains(":") && (dir = resultsFolder.split(":")[0]).contains(File.separator)) {
                dir = dir.split(File.separator + File.separator)[0];
                resultsFolder = dir + ":" + resultsFolder.split(":")[1];
            }
            this.setResultsFolder(FilenameUtils.separatorsToSystem((String)resultsFolder));
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.options);
            return false;
        }
        catch (NumberFormatException ex) {
            new HelpFormatter().printHelp(ExperimeterCLI.class.getCanonicalName(), this.options);
            return false;
        }
        return true;
    }

    public String[] getAlgorithms() {
        return this.algorithms;
    }

    public String[] getAlgorithmsID() {
        return this.algorithmsID;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getResultsFolder() {
        return this.resultsFolder;
    }

    public String getSaveExperimentsPath() {
        return this.saveExperimentsPath;
    }

    public String[] getStreams() {
        return this.streams;
    }

    public String[] getStreamsID() {
        return this.streamsID;
    }

    public String getTask() {
        return this.task;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setAlgorithms(String[] algorithms) {
        this.algorithms = algorithms;
    }

    public void setAlgorithmsID(String[] algorithmsID) {
        this.algorithmsID = algorithmsID;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setResultsFolder(String resultsFolder) {
        this.resultsFolder = resultsFolder;
    }

    public void setSaveExperimentsPath(String saveExperimentsPath) {
        this.saveExperimentsPath = saveExperimentsPath;
    }

    public void setStreams(String[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            streams[i] = FilenameUtils.separatorsToSystem((String)streams[i]);
        }
        this.streams = streams;
    }

    public void setStreamsID(String[] streamsID) {
        this.streamsID = streamsID;
    }

    public void setStreamIndex(int index, String streamID) {
        this.streams[index] = streamID;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }
}

