% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displayStruc.R
\name{displayStruc}
\alias{displayStruc}
\title{Construct text For \code{strucplot} legends.}
\usage{
displayStruc(struc, heading = c("Horizontal", "Vertical"),
  miss = "No Conditioning", abbrevLength = c(0, 0), ...)
}
\arguments{
\item{struc}{The "structure" attribute of a \code{strucplot} object}

\item{heading}{A character vector of length 2 giving the headings for the horizontal
and vertical conditioning variables portions of the legend. Default =
\code{c("Horizontal", "Vertical")}.}

\item{miss}{A character string to use when there is no conditioning either horizontally
or vertically. Default = \code{"No Conditioning"}}

\item{abbrevLength}{Default = \code{c(0,0)}. Either a length 2 vector or a named list
to control lengths of factor names and levels in the legend. If a length 2 vector, it
gives the \code{minlength} argument for the abbreviate function for abbreviating all
the factor names and their levels, in that order. A value of 0 for either means
"don't abbreviate." For back compatibility, a single numeric y will also be accepted
and changed to \code{c(y,0)}. If a named list, the names must be those of of the
conditioning factors to abbreviate, and values length 2 vectors as above to
control abbreviation lengths for the corresponding factor names and levels.}

\item{...}{Additional arguments, presently ignored}
}
\value{
A character vector of length 2 giving character strings,
 including \code{\\n} line breaks.
}
\description{
Construct character strings for print and legend functions to display on
the console or lattice plot.
}
\details{
This is an exported auxiliary function that constructs the character strings
for displaying plot structure on the console and possibly also in a legend on the
lattice display. While not intended to be directly called by the user, it is exported
for use by those who wish to supply custom legends for the lattice display.
}
\examples{
require(datasets)
# quakes data
#
# Create and save plot
 out <- strucplot(lat ~ long|cut(mag,5)*cut(depth,4), data = quakes,
  col="blue", main = "Earthquake locations, by magnitude and depth")

 displayStruc(attr(out,"structure"))
}

