% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{strs_slice}
\alias{strs_slice}
\title{Slice substrings from a string}
\usage{
strs_slice(string, start = 1L, stop = -1L, ..., step = 1L)
}
\arguments{
\item{string}{A character vector where each element is a string to slice.}

\item{start}{An integerish scalar for the starting position for slicing (inclusive).}

\item{stop}{An integerish scalar for the ending position for slicing (inclusive).}

\item{...}{Used to force keyword argument usage of \code{step}.}

\item{step}{An integer greater than 0 or equal to -1 for the step size. If -1 is provided,
each string will be reversed after slicing operations.}
}
\value{
A character vector of the same length as \code{string}, with each element
being the sliced substring.
}
\description{
\code{strs_slice} extracts substrings from each element of a character vector,
specified by start and stop positions. It is similar to Python's slicing
syntax for strings, but it uses 1 indexing and stops are inclusive.
}
\examples{
strs_slice("hello world", 1, 5)
strs_slice("hello world", 7)
strs_slice("hello world", start = 7, stop = 11)
}
