% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_explore.R
\name{response_hour_hist}
\alias{response_hour_hist}
\title{response_hour_hist}
\usage{
response_hour_hist(
  tab,
  break_hours = 10,
  xlab = "Hours into study",
  main = paste0("Distribution of ", attr(tab, "table"), " response times"),
  ...
)
}
\arguments{
\item{tab}{A StudentLife tibble with time information,
(i.e., and object of class \code{timestamp_SL_tbl}
or \code{interval_SL_tbl}) as can be returned by the function
\code{\link[studentlife]{load_SL_tibble}}.}

\item{break_hours}{Specify the width in hours of each
histogram bin.}

\item{xlab}{Argument passed to \code{\link[graphics]{hist}}.}

\item{main}{Argument passed to \code{\link[graphics]{hist}}.}

\item{...}{Arguments passed to \code{\link[graphics]{hist}}.}
}
\description{
This function produces a histogram that visualizes the
frequencies of observations within hourly blocks,
or blocks of multiple hours.
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

tab_PAM <- load_SL_tibble(schema = "EMA", table = "PAM", location = d)

response_hour_hist(tab_PAM)

}
