% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervisedPRIM.R
\name{supervisedPRIM}
\alias{supervisedPRIM}
\title{Fit PRIM model to a labeled dataset}
\usage{
supervisedPRIM(x, y, peel.alpha = 0.05, paste.alpha = 0.01,
  mass.min = 0.05, threshold.type = 1, ...)
}
\arguments{
\item{x}{matrix of data values}

\item{y}{binary vector of 0/1 response values}

\item{peel.alpha}{peeling quantile tuning parameter}

\item{paste.alpha}{pasting quantile tuning parameter}

\item{mass.min}{minimum mass tuning parameter}

\item{threshold.type}{threshold direction indicator: 1 = ">= threshold",
-1 = "<= threshold"}

\item{...}{additional arguments to pass to \code{\link[prim]{prim.box}}}
}
\value{
an object of class \code{supervisedPRIM}. See additional details
in \link[prim]{prim.box}
}
\description{
perform supervised classification using Patient Rule Induction Method (PRIM)
}
\details{
Fit
}
\examples{
# Train a model to determine if a flower is setosa
data(iris)
yData <- factor(ifelse(iris$Species == "setosa", "setosa", "other"), levels = c("setosa", "other"))
xData <- iris
xData$Species <- NULL
primModel <- supervisedPRIM(x = xData, y = yData)
}
\author{
David Shaub
}

